/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.plugin;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ManagementDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorMergeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;

public class PluginDescriptorMergeService
extends ResourceManagementService
implements IPluginDescriptorMergeService {
    private static final Logger LOGGER = Logger.getLogger(PluginDescriptorMergeService.class);

    @Override
    public ResourceType mergeResourceType(ResourceTypeDescriptor descriptor, ResourceType resourceType) {
        this.validateResourceTypeDescriptor(descriptor, resourceType);
        boolean create = resourceType == null;
        ResourceType result = create ? new ResourceType() : resourceType;
        result.setName(descriptor.getName());
        result.setSystemId(descriptor.getSystemId());
        result.setSendCreatedEvent(create);
        result.setConnectionType(descriptor.getManagement().getConnectionType());
        result.setHeartbeatConnectionType(descriptor.getManagement().getHeartbeatConnectionType());
        result.setNotLicensed(!descriptor.isLicensed());
        result.setPluginMissing(false);
        return result;
    }

    @Override
    public boolean validateResourceTypeDescriptor(ResourceTypeDescriptor descriptor, ResourceType resourceType) {
        if (resourceType != null) {
            String msg;
            ManagementDescriptor mgmt = descriptor.getManagement();
            if (mgmt.getConnectionType() != resourceType.getConnectionType()) {
                msg = "The Connection Type for: " + descriptor.getSystemId() + " - " + descriptor.getName() + " is being changed from " + (Object)((Object)resourceType.getConnectionType()) + " to " + (Object)((Object)mgmt.getConnectionType()) + ", current resources will have invalid connection strings.";
                LOGGER.warn((Object)msg);
            }
            if (mgmt.getHeartbeatConnectionType() != resourceType.getHeartbeatConnectionType()) {
                msg = "The Heartbeat Connection Type for: " + descriptor.getSystemId() + " - " + descriptor.getName() + " is being changed from " + (Object)((Object)resourceType.getHeartbeatConnectionType()) + " to " + (Object)((Object)mgmt.getHeartbeatConnectionType()) + ", current resources will have invalid heartbeat connection strings.";
                LOGGER.warn((Object)msg);
            }
        }
        return true;
    }

    @Override
    public ResourceGroup mergeResourceGroup(ResourceGroupDescriptor descriptor, ResourceGroup resourceGroup, ResourceType resourceType) {
        ResourceGroup result;
        if (!this.validateResourceGroupDescriptor(descriptor, resourceGroup)) {
            return null;
        }
        if (resourceType == null) {
            String message = "Resource Type for System ID: " + descriptor.getSystemId() + " is inactive or not found in database.";
            this.getPluginManager().notifyUnacceptedResourceGroupDescriptor(descriptor, message);
            return null;
        }
        boolean create = resourceGroup == null;
        ResourceGroup resourceGroup2 = result = create ? new ResourceGroup() : resourceGroup;
        if (create) {
            result.setName(descriptor.getName());
            result.setResourceType(resourceType);
            result.setAllocatable(true);
        }
        result.setSendCreatedEvent(create);
        IAuthorizationManager service = this.getAuthorizationManager();
        int protectionKeyId = service.getProtectionKeyIDForName(descriptor.getAccessLevel(), true);
        result.setFunctionalType(descriptor.getFunctionalType());
        result.setProtectionKeyId(protectionKeyId);
        result.setInternallyAcquired(descriptor.getIsInternallyAcquired());
        return result;
    }

    @Override
    public boolean validateResourceGroupDescriptor(ResourceGroupDescriptor descriptor, ResourceGroup resourceGroup) {
        Collection<String> errors = this.validateGroupDescriptor(descriptor, resourceGroup);
        if (!errors.isEmpty()) {
            this.getPluginManager().notifyUnacceptedResourceGroupDescriptor(descriptor, errors);
            return false;
        }
        return true;
    }

    private Collection<String> validateGroupDescriptor(ResourceGroupDescriptor descriptor, ResourceGroup resourceGroup) {
        ArrayList<String> messages = new ArrayList<String>();
        String systemId = descriptor.getSystemId();
        ResourceTypeDescriptor typeDescriptor = this.getResourceTypeDescriptor(systemId);
        if (resourceGroup == null && typeDescriptor == null) {
            messages.add("Resource Type for System ID: " + descriptor.getSystemId() + " is inactive or not found in database.");
        } else if (resourceGroup != null) {
            boolean hasResources;
            String oldSystemId = resourceGroup.getResourceType().getSystemId();
            if (!oldSystemId.equals(systemId)) {
                messages.add("Resource Type cannot be changed.");
            } else if (typeDescriptor == null) {
                messages.add("Resource Type for System ID: " + descriptor.getSystemId() + " is inactive or not found in database.");
            }
            IAuthorizationManager service = this.getAuthorizationManager();
            Set<Resource> resources = resourceGroup.getResources();
            boolean bl = hasResources = resources != null && !resources.isEmpty();
            if (hasResources) {
                String oldType;
                String type;
                String protectionKeyName = descriptor.getAccessLevel();
                int protectionKeyId = service.getProtectionKeyIDForName(protectionKeyName, false);
                if (protectionKeyId != resourceGroup.getProtectionKeyId()) {
                    messages.add("Access Level cannot be changed | Reason: Resource Group has Resources.");
                }
                if (!((type = descriptor.getFunctionalType()) == (oldType = resourceGroup.getFunctionalType()) || type != null && type.equals(oldType))) {
                    messages.add("Functional Type cannot be changed | Reason: Resource Group has Resources.");
                }
            }
        }
        return messages;
    }

    private ResourceTypeDescriptor getResourceTypeDescriptor(String systemId) {
        ResourceTypeDescriptor result = this.getPluginManager().getResourceTypeDescriptor(systemId);
        if (result == null) {
            result = this.getPluginManager().getNonLicensedDescriptor(systemId);
        }
        return result;
    }

    private PluginManagement getPluginManager() {
        return (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
    }

    private IAuthorizationManager getAuthorizationManager() {
        return (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
    }
}

