/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resource;

import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.AllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.IResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.ResourceTypeContainer;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.event.ResourceDeletedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupSubscribeEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceGroupUnsubscribeEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.license.ILicenseService;
import com.tandbergtv.workflow.resourcemanager.util.ResourceValidator;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class LocalResourceService
extends ResourceManagementService
implements IResourceService,
IResourceTypeIdAware {
    private static final Logger logger = Logger.getLogger(LocalResourceService.class);
    private final ThreadLocal<Long> localResourceTypeId = new ThreadLocal();
    private final IAllocationKeyService allocationKeyService = new AllocationKeyService();

    @Override
    public List<Resource> getAllResources() {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        for (Serializable key : this.getLocalKeys()) {
            Collection resources = cache.get(key);
            if (resources == null) continue;
            for (Resource cachedResource : resources) {
                resourceList.add(this.clone(cachedResource));
            }
        }
        return resourceList;
    }

    @Override
    public List<Resource> getResourcesBySearchCriteria(SearchCriteria searchCriteria) throws DataOperationException {
        throw new RuntimeException("Operation not suppported.");
    }

    @Override
    public int getActiveResourcesCount() {
        int count = 0;
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        for (Serializable key : this.getLocalKeys()) {
            count += cache.valueCount(key);
        }
        return count;
    }

    @Override
    public Resource getResource(long resourceId) throws FinderException, DataOperationException {
        Resource match = null;
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                Resource resource = this.getResource(cache.get(key), resourceId);
                if (resource == null) continue;
                match = resource;
                break;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            match = this.getResource(cache.get((Serializable)resourceTypeId), resourceId);
        }
        if (match == null) {
            String msg = "Could not find Resource with Id: " + resourceId;
            throw new FinderException(msg);
        }
        return match;
    }

    @Override
    public Resource getResourceByName(String resourceName) throws FinderException, DataOperationException {
        Resource match = null;
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                Resource resource = this.getResourceByName(cache.get(key), resourceName);
                if (resource == null) continue;
                match = resource;
                break;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            match = this.getResourceByName(cache.get((Serializable)resourceTypeId), resourceName);
        }
        if (match == null) {
            String msg = "Could not find Resource with Id: " + resourceName;
            throw new FinderException(msg);
        }
        return match;
    }

    private Resource getResource(Collection<Resource> resources, long resourceId) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (resource.getId() != resourceId) continue;
                return this.clone(resource);
            }
        }
        return null;
    }

    private Resource getResourceByName(Collection<Resource> resources, String resourceName) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (!resource.getName().equals(resourceName)) continue;
                return this.clone(resource);
            }
        }
        return null;
    }

    @Override
    public List<Resource> getResourcesByResourceType(long resourceTypeId) {
        Collection resources;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        if (this.getLocalKeys().contains(resourceTypeId) && (resources = this.getResourceCache().get((Serializable)Long.valueOf(resourceTypeId))) != null) {
            for (Resource cachedResource : resources) {
                resourceList.add(this.clone(cachedResource));
            }
        }
        return resourceList;
    }

    @Override
    public List<Resource> getResourcesBySystemId(String systemId) {
        if (systemId == null) {
            return null;
        }
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId != null) {
            return this.getResourcesByResourceType(resourceTypeId);
        }
        IDistributedCache<ResourceType> typeCache = this.getResourceTypeCache();
        for (Serializable key : this.getLocalKeys()) {
            ResourceType resourceType = (ResourceType)typeCache.get(key);
            if (!systemId.equals(resourceType.getSystemId())) continue;
            return this.getResourcesByResourceType(resourceTypeId);
        }
        return new ArrayList<Resource>();
    }

    @Override
    public List<Resource> getResourcesByGroup(long resourceGroupId) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        ResourceGroup group = new ResourceGroup(resourceGroupId);
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                if (!this.getResourcesByGroup(cache.get(key), group, resources)) continue;
                return resources;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            this.getResourcesByGroup(cache.get((Serializable)resourceTypeId), group, resources);
        }
        return resources;
    }

    @Override
    public List<Resource> getResourcesByGroupName(String resourceGroupName) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        ResourceGroup group = new ResourceGroup();
        group.setName(resourceGroupName);
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                if (!this.getResourcesByGroupName(cache.get(key), group, resources)) continue;
                return resources;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            this.getResourcesByGroupName(cache.get((Serializable)resourceTypeId), group, resources);
        }
        return resources;
    }

    private boolean getResourcesByGroup(Collection<Resource> resources, ResourceGroup group, List<Resource> result) {
        boolean added = false;
        if (resources != null) {
            for (Resource resource : resources) {
                if (!resource.getResourceGroups().contains(group)) continue;
                result.add(this.clone(resource));
                added = true;
            }
        }
        return added;
    }

    private boolean getResourcesByGroupName(Collection<Resource> resources, ResourceGroup group, List<Resource> result) {
        boolean added = false;
        if (resources != null) {
            for (Resource resource : resources) {
                for (ResourceGroup resourceGroup : resource.getResourceGroups()) {
                    if (!resourceGroup.getName().equals(group.getName())) continue;
                    result.add(this.clone(resource));
                    added = true;
                }
            }
        }
        return added;
    }

    @Override
    public Resource getResourceByToken(long tokenId) {
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        ResourceUser user = new ResourceUser(tokenId);
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                Resource resource = this.getResourceByToken(cache.get(key), user);
                if (resource == null) continue;
                return resource;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            return this.getResourceByToken(cache.get((Serializable)resourceTypeId), user);
        }
        return null;
    }

    private Resource getResourceByToken(Collection<Resource> resources, ResourceUser user) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (!resource.getUsers().contains(user)) continue;
                return this.clone(resource);
            }
        }
        return null;
    }

    @Override
    public Resource getResourceByUser(String userName) {
        if (userName == null) {
            return null;
        }
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                Resource resource = this.getResourceByUser(cache.get(key), userName);
                if (resource == null) continue;
                return resource;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            return this.getResourceByUser(cache.get((Serializable)resourceTypeId), userName);
        }
        return null;
    }

    private Resource getResourceByUser(Collection<Resource> resources, String userName) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (!userName.equals(resource.getUserName())) continue;
                return this.clone(resource);
            }
        }
        return null;
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString) {
        if (connectionString == null) {
            return null;
        }
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getLocalKeys()) {
                Resource resource = this.getResourceByConnectionString(cache.get(key), connectionString);
                if (resource == null) continue;
                return resource;
            }
        } else if (this.getLocalKeys().contains(resourceTypeId)) {
            return this.getResourceByConnectionString(cache.get((Serializable)resourceTypeId), connectionString);
        }
        return null;
    }

    private Resource getResourceByConnectionString(Collection<Resource> resources, String connectionString) {
        if (resources != null) {
            for (Resource resource : resources) {
                if (!connectionString.equals(resource.getConnectionString())) continue;
                return this.clone(resource);
            }
        }
        return null;
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString, long groupId) {
        Resource resource = this.getResourceByConnectionString(connectionString);
        if (resource != null) {
            ResourceGroup group = new ResourceGroup(groupId);
            if (resource.getResourceGroups().contains(group)) {
                return resource;
            }
        }
        return null;
    }

    @Override
    public Resource setResourceOnline(long resourceId) throws FinderException, DataOperationException {
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        String name = "resource[" + resourceId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (ResourceState.ONLINE != ((Resource)container.getEntity()).getAdministrationState()) {
                Resource clone = this.getCloneService().cloneResource((Resource)container.getEntity(), false);
                clone.setAdministrationState(ResourceState.ONLINE);
                try {
                    this.updateResourceInTransaction(clone);
                }
                catch (RuntimeException ex) {
                    String msg = "Failed to update the Resource Administration Status to Online in the Database.";
                    throw new DataOperationException(msg, ex);
                }
                ((Resource)container.getEntity()).setAdministrationState(ResourceState.ONLINE);
                container.updateEntity();
                logger.info((Object)("Resource" + container.getEntity() + " is scheduled to go Online."));
                if (this.getStateManager().initializeResource(container)) {
                    container.updateEntity(true);
                }
            } else {
                logger.debug((Object)("Resource" + container.getEntity() + " is already set Online."));
            }
            Resource resource = this.clone((Resource)container.getEntity());
            return resource;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public Resource setResourceOffline(long resourceId) throws FinderException, DataOperationException {
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        String name = "resource[" + resourceId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (ResourceState.OFFLINE != ((Resource)container.getEntity()).getAdministrationState()) {
                Resource clone = this.getCloneService().cloneResource((Resource)container.getEntity(), false);
                clone.setAdministrationState(ResourceState.OFFLINE);
                try {
                    this.updateResourceInTransaction(clone);
                }
                catch (RuntimeException ex) {
                    String msg = "Failed to update the Resource Administration Status to Online in the Database.";
                    throw new DataOperationException(msg, ex);
                }
                ((Resource)container.getEntity()).setAdministrationState(ResourceState.OFFLINE);
                container.updateEntity();
                logger.info((Object)("Resource" + container.getEntity() + " is scheduled to go Offline."));
                if (this.getStateManager().tryTakeResourceOffline(container)) {
                    container.updateEntity(true);
                }
            } else {
                logger.debug((Object)("Resource" + container.getEntity() + " is already set Offline."));
            }
            Resource resource = this.clone((Resource)container.getEntity());
            return resource;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public Resource createResource(Resource resource) throws ValidationException, DataOperationException {
        Long resourceTypeId = resource.getResourceType().getId();
        if (!this.getLocalKeys().contains(resourceTypeId)) {
            ValidationException ve = new ValidationException();
            ve.addErrorCode("VR-101");
            throw ve;
        }
        if (resource.getId() != -1L) {
            ValidationException ve = new ValidationException();
            ve.addErrorCode("VR-203");
            throw ve;
        }
        resource.setOperationalState(ResourceState.OFFLINE);
        resource.setActive(true);
        resource.getUsers().clear();
        HashSet<Long> addedGroups = new HashSet<Long>();
        ResourceTypeContainer typeContainer = (ResourceTypeContainer)this.getResourceTypeContainerCache().get((Serializable)resourceTypeId);
        String name = "resource type[" + resourceTypeId + "]";
        this.getContainerService().verifyContainerReady(name, typeContainer);
        typeContainer.getReadLock().lock();
        try {
            this.getContainerService().verifyContainerReady(typeContainer);
            for (ResourceGroup group : resource.getResourceGroups()) {
                addedGroups.add(group.getId());
            }
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceDAI resDAI = factory.getResourceDAO();
            Session session = this.getPersistenceService().getCurrentSession();
            String systemId = ((ResourceType)typeContainer.getEntity()).getSystemId();
            this.tryIncrementResourceCount(systemId);
            boolean success = false;
            this.getPersistenceService().beginTransaction(session);
            try {
                try {
                    this.validateResourceProperties(resource);
                    resource = resDAI.create(resource);
                    this.getPersistenceService().commitTransaction(session);
                    success = true;
                }
                catch (RuntimeException ex) {
                    this.getPersistenceService().rollbackTransaction(session);
                    String msg = "Failed to create the Resource in the Database.";
                    throw new DataOperationException(msg, ex);
                }
            }
            finally {
                if (!success) {
                    this.decrementResourceCount(systemId);
                }
            }
            Resource resourceForCache = this.clone(resource);
            ResourceContainer container = this.getContainerService().createResourceContainer(resourceForCache);
            resource = this.clone((Resource)container.getEntity());
        }
        finally {
            typeContainer.getReadLock().unlock();
        }
        this.addResourceToGroups(resource.getId(), addedGroups);
        return resource;
    }

    @Override
    public Resource updateResource(Resource resource) throws ValidationException, ActionException, FinderException, DataOperationException {
        HashSet<Long> addedGroups = new HashSet<Long>();
        HashSet<Long> removedGroups = new HashSet<Long>();
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resource.getId()));
        if (!this.verifyContainerReady(resource.getId(), container)) {
            String msg = "Failed to update Resource with id=" + resource.getId() + ", no such Resource exists.";
            throw new FinderException(msg);
        }
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            this.validateResourceForModification(container, true);
            Resource cachedResource = (Resource)container.getEntity();
            for (ResourceGroup group : resource.getResourceGroups()) {
                if (cachedResource.getResourceGroups().contains(group)) continue;
                addedGroups.add(group.getId());
            }
            for (ResourceGroup group : cachedResource.getResourceGroups()) {
                if (resource.getResourceGroups().contains(group)) continue;
                removedGroups.add(group.getId());
            }
            resource.setOperationalState(cachedResource.getOperationalState());
            resource.setActive(true);
            Session session = this.getPersistenceService().getCurrentSession();
            ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                this.validateResourceProperties(resource);
                resource = dao.update(resource);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException ex) {
                this.getPersistenceService().rollbackTransaction(session);
                throw new DataOperationException("Failed to update the Resource in the Database.", ex);
            }
            Resource resourceForCache = this.clone(resource);
            container.setEntity(resourceForCache);
            if (this.getStateManager().initializeResource(container)) {
                container.updateEntity(true);
            }
            resource = this.clone((Resource)container.getEntity());
        }
        finally {
            container.getWriteLock().unlock();
        }
        this.addResourceToGroups(resource.getId(), addedGroups);
        this.removeResourceFromGroups(resource.getId(), removedGroups);
        return resource;
    }

    @Override
    public boolean deleteResource(long resourceId) throws ActionException, DataOperationException {
        Resource resource;
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (!this.verifyContainerReady(resourceId, container)) {
            return false;
        }
        HashSet<Long> removedGroups = new HashSet<Long>();
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            this.validateResourceForModification(container, false);
            for (ResourceGroup group : ((Resource)container.getEntity()).getResourceGroups()) {
                removedGroups.add(group.getId());
            }
            resource = this.getCloneService().cloneResource((Resource)container.getEntity(), false);
            resource.removeAllResourceGroups();
            resource.setActive(false);
            resource.setUserName(null);
            Session session = this.getPersistenceService().getCurrentSession();
            ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                resource = dao.update(resource);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException ex) {
                this.getPersistenceService().rollbackTransaction(session);
                throw new DataOperationException("Failed to delete " + container + " from the Database.", ex);
            }
            this.getContainerService().deleteResourceContainer(resource.getId());
        }
        finally {
            container.getWriteLock().unlock();
        }
        container.destroy();
        resource = (Resource)container.getEntity();
        this.decrementResourceCount(resource.getResourceType().getSystemId());
        this.removeResourceFromGroups(resourceId, removedGroups);
        this.getEventHandler().handleEvent(new ResourceDeletedEvent(resource));
        return true;
    }

    @Override
    public boolean isResourceActive(long resourceId) {
        throw new RuntimeException("Operation not supported.");
    }

    @Override
    public IAllocationKeyService getAllocationKeyService() {
        return this.allocationKeyService;
    }

    @Override
    public ComponentHealthStatus getHealthStatus() {
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        for (Serializable key : this.getLocalKeys()) {
            Collection resources = cache.get(key);
            if (resources == null) continue;
            for (Resource resource : resources) {
                switch (resource.getOperationalState()) {
                    case INITIALIZATION_ERROR: 
                    case HEARTBEAT_ERROR: 
                    case ERROR: {
                        return ComponentHealthStatus.ERROR;
                    }
                }
            }
        }
        return ComponentHealthStatus.OK;
    }

    private Resource clone(Resource resource) {
        return this.getCloneService().cloneResource(resource);
    }

    private Resource updateResourceInTransaction(Resource resource) {
        Session session = this.getPersistenceService().getCurrentSession();
        ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
        this.getPersistenceService().beginTransaction(session);
        try {
            resource = dao.update(resource);
            this.getPersistenceService().commitTransaction(session);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(session);
            throw ex;
        }
        return resource;
    }

    private boolean verifyContainerReady(long resourceId, ResourceContainer container) {
        ResourceManagement manager = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        if ((container == null || container.isStopped()) && !manager.isResourceActive(resourceId)) {
            return false;
        }
        String name = "resource[" + resourceId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        return true;
    }

    private void validateResourceProperties(Resource resource) throws ValidationException {
        ResourceValidator.validateResource(resource);
        ArrayList<String> errorList = new ArrayList<String>();
        ResourceDAI dao = this.getPersistenceService().getDataAccessObjectFactory().getResourceDAO();
        if (resource.getId() != -1L) {
            long resourceTypeId = resource.getResourceType().getId();
            Long oldTypeId = dao.findResourceTypeIDByKey(resource.getId());
            if (oldTypeId == null || !oldTypeId.equals(resourceTypeId)) {
                errorList.add("VR-201");
            }
        }
        if (!dao.isNameUnique(resource)) {
            errorList.add("VR-200");
        }
        if (!dao.isConnectionStringUnique(resource)) {
            errorList.add("VR-202");
        }
        if (errorList.size() > 0) {
            ValidationException ve = new ValidationException();
            ve.setErrorCodes(errorList);
            throw ve;
        }
    }

    private void validateResourceForModification(ResourceContainer container, boolean isUpdate) throws ActionException {
        boolean validAdminState;
        String operation = isUpdate ? "update" : "delete";
        Resource resource = (Resource)container.getEntity();
        if (resource.getUserCount() != 0) {
            int userCount = resource.getUserCount();
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Resource currently has " + userCount + " users.";
            throw new ActionException(msg, "AE-100");
        }
        boolean validOpState = ResourceState.OFFLINE == resource.getOperationalState() || ResourceState.INACTIVE == resource.getOperationalState() && !isUpdate || ResourceState.INVALID == resource.getOperationalState() && !isUpdate;
        boolean bl = validAdminState = ResourceState.OFFLINE == resource.getAdministrationState() || ResourceState.INACTIVE == resource.getOperationalState() && !isUpdate || ResourceState.INVALID == resource.getOperationalState() && !isUpdate;
        if (!validOpState) {
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Operational State is not Offline.";
            throw new ActionException(msg, "AE-102");
        }
        if (!validAdminState) {
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Administration State is not Offline.";
            throw new ActionException(msg, "AE-103");
        }
    }

    private void addResourceToGroups(long resourceId, Set<Long> resourceGroupIds) {
        for (Long groupId : resourceGroupIds) {
            this.getEventHandler().handleEvent(new ResourceGroupSubscribeEvent(groupId, resourceId));
        }
    }

    private void removeResourceFromGroups(long resourceId, Set<Long> resourceGroupIds) {
        for (Long groupId : resourceGroupIds) {
            this.getEventHandler().handleEvent(new ResourceGroupUnsubscribeEvent(groupId, resourceId));
        }
    }

    private void tryIncrementResourceCount(String systemId) throws ValidationException {
        boolean isHuman = "04".equals(systemId);
        boolean addResource = false;
        addResource = isHuman ? this.getLicenseService().tryIncrementHumanResourceCount() : this.getLicenseService().tryIncrementSystemResourceCount();
        if (!addResource) {
            ValidationException ve = new ValidationException();
            if (isHuman) {
                ve.addErrorCode("VR-301");
            } else {
                ve.addErrorCode("VR-302");
            }
            throw ve;
        }
    }

    private void decrementResourceCount(String systemId) {
        if ("04".equals(systemId)) {
            this.getLicenseService().decrementHumanResourceCount();
        } else {
            this.getLicenseService().decrementSystemResourceCount();
        }
    }

    private Long getResourceTypeIdForRequest() {
        return this.localResourceTypeId.get();
    }

    @Override
    public void setResourceTypeIdForRequest(Long resourceTypeId) {
        this.localResourceTypeId.set(resourceTypeId);
    }

    @Override
    public void removeResourceTypeIdForRequest() {
        this.localResourceTypeId.remove();
    }

    @Override
    public String getServiceName() {
        return "LocalResourceService";
    }

    private Collection<Serializable> getLocalKeys() {
        return this.getResourceTypeCache().localKeySet();
    }

    private IDistributedCache<ResourceType> getResourceTypeCache() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private ICacheService<ResourceTypeContainer> getResourceTypeContainerCache() {
        return (ICacheService)this.getService("ResourceTypeContainerCache");
    }

    private IMultiValueCacheService<Resource> getResourceCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceCache");
    }

    private ICacheService<ResourceContainer> getResourceContainerCache() {
        return (ICacheService)this.getService("ResourceContainerCache");
    }

    private IHibernatePersistenceService getPersistenceService() {
        return this.getService(IHibernatePersistenceService.class);
    }

    private ILicenseService getLicenseService() {
        return this.getService(ILicenseService.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private IContainerService getContainerService() {
        return this.getService(IContainerService.class);
    }

    private IEventHandler getEventHandler() {
        return (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
    }

    private ResourceStateManager getStateManager() {
        return this.getService(ResourceStateManager.class);
    }
}

