/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.entity;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueue;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.Set;

public class ResourceGroupProxy
extends ResourceGroup {
    private static final long serialVersionUID = -2718240428703372226L;
    private transient ResourceGroup resourceGroup = null;

    public ResourceGroupProxy() {
    }

    public ResourceGroupProxy(long resourceGroupId) {
        super(resourceGroupId);
    }

    @Override
    public String getFunctionalType() {
        return this.getResourceGroup().getFunctionalType();
    }

    @Override
    public void setFunctionalType(String functionalType) {
        this.getResourceGroup().setFunctionalType(functionalType);
    }

    @Override
    public boolean isVisible() {
        return this.getResourceGroup().isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.getResourceGroup().setVisible(visible);
    }

    @Override
    public boolean isAllocatable() {
        return this.getResourceGroup().isAllocatable();
    }

    @Override
    public void setAllocatable(boolean allocatable) {
        this.getResourceGroup().setAllocatable(allocatable);
    }

    @Override
    public boolean isInternallyAcquired() {
        return this.getResourceGroup().isInternallyAcquired();
    }

    @Override
    public void setInternallyAcquired(boolean internallyAcquired) {
        this.getResourceGroup().setInternallyAcquired(internallyAcquired);
    }

    @Override
    public String getName() {
        return this.getResourceGroup().getName();
    }

    @Override
    public void setName(String name) {
        this.getResourceGroup().setName(name);
    }

    @Override
    public ResourceType getResourceType() {
        return this.getResourceGroup().getResourceType();
    }

    @Override
    public void setResourceType(ResourceType resourceType) {
        this.getResourceGroup().setResourceType(resourceType);
    }

    @Override
    public Set<Resource> getResources() {
        return this.getResourceGroup().getResources();
    }

    @Override
    public void setResources(Set<Resource> resources) {
        this.getResourceGroup().setResources(resources);
    }

    @Override
    public void removeAllResources() {
        this.getResourceGroup().removeAllResources();
    }

    @Override
    public void addResource(Resource resource) {
        this.getResourceGroup().addResource(resource);
    }

    @Override
    public void removeResource(Resource resource) {
        this.getResourceGroup().removeResource(resource);
    }

    @Override
    public ResourceGroupQueue getQueue() {
        return this.getResourceGroup().getQueue();
    }

    @Override
    public void setQueue(ResourceGroupQueue queue) {
        this.getResourceGroup().setQueue(queue);
    }

    @Override
    public int getProtectionKeyId() {
        return this.getResourceGroup().getProtectionKeyId();
    }

    @Override
    public void setProtectionKeyId(int protectionKeyId) {
        this.getResourceGroup().setProtectionKeyId(protectionKeyId);
    }

    @Override
    public boolean isSendCreatedEvent() {
        return this.getResourceGroup().isSendCreatedEvent();
    }

    @Override
    public void setSendCreatedEvent(boolean sendCreatedEvent) {
        this.getResourceGroup().setSendCreatedEvent(sendCreatedEvent);
    }

    @Override
    public boolean isConsumerTracingDisabled() {
        return this.getResourceGroup().isConsumerTracingDisabled();
    }

    @Override
    public void setConsumerTracingDisabled(boolean consumerTracingDisabled) {
        this.getResourceGroup().setConsumerTracingDisabled(consumerTracingDisabled);
    }

    @Override
    public boolean equals(Object obj) {
        return this.getLightWeightResourceGroup().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getLightWeightResourceGroup().hashCode();
    }

    @Override
    public ResourceGroupProxy clone() {
        return (ResourceGroupProxy)super.clone();
    }

    @Override
    public String toString() {
        return "[" + this.getId() + "] ";
    }

    private ResourceGroup getResourceGroup() {
        if (this.resourceGroup == null) {
            try {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                ResourceManagement manager = (ResourceManagement)registry.lookup(ResourceManagement.class);
                this.resourceGroup = manager.getResourceGroup(this.getId());
            }
            catch (ResourceManagementException e) {
                this.resourceGroup = this.getLightWeightResourceGroup();
            }
        }
        return this.resourceGroup;
    }

    private ResourceGroup getLightWeightResourceGroup() {
        return new ResourceGroup(this.getId());
    }
}

