/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal;

import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceTypeDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import java.io.Serializable;
import org.hibernate.Session;

public class ResourceManagementLocatorService
extends ResourceManagementService
implements ILocatorService {
    private ICacheService<Long> resourceTypeIdCache;
    private static final String RESOURCE_TYPE_ID_CACHE = "ResourceTypeIDCache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceContainer findResource(long tokenId) {
        ResourceContainer match = null;
        ResourceUser user = new ResourceUser(tokenId);
        ICacheService<ResourceContainer> cache = this.getResourceCache();
        for (Serializable key : cache.getKeys()) {
            ResourceContainer container = (ResourceContainer)cache.get(key);
            if (container == null) continue;
            container.getReadLock().lock();
            try {
                Resource resource = (Resource)container.getEntity();
                if (!resource.getUsers().contains(user)) continue;
                match = container;
                break;
            }
            finally {
                container.getReadLock().unlock();
            }
        }
        return match;
    }

    @Override
    public Long getResourceTypeIdForGroup(long resourceGroupId) {
        Long resourceTypeId = (Long)this.resourceTypeIdCache.get((Serializable)new Long(resourceGroupId));
        if (resourceTypeId == null) {
            IHibernatePersistenceService persistenceService = this.getPersistenceService();
            DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
            ResourceGroupDAI dao = factory.getResourceGroupDAO();
            Session currentSession = persistenceService.getCurrentSession();
            persistenceService.beginTransaction(currentSession);
            try {
                resourceTypeId = dao.findResourceTypeIDByKey(resourceGroupId);
                persistenceService.commitTransaction(currentSession);
            }
            catch (RuntimeException ex) {
                this.getPersistenceService().rollbackTransaction(currentSession);
                throw ex;
            }
            if (resourceTypeId != null) {
                this.setResourceTypeIdForGroup(resourceGroupId, resourceTypeId);
            }
        }
        return resourceTypeId;
    }

    @Override
    public Long getResourceTypeIdForGroupName(String resourceGroupName) {
        Long resourceTypeId = null;
        IHibernatePersistenceService persistenceService = this.getPersistenceService();
        DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
        ResourceGroupDAI dao = factory.getResourceGroupDAO();
        Session currentSession = persistenceService.getCurrentSession();
        persistenceService.beginTransaction(currentSession);
        try {
            resourceTypeId = dao.findResourceTypeByGroupName(resourceGroupName);
            persistenceService.commitTransaction(currentSession);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(currentSession);
            throw ex;
        }
        return resourceTypeId;
    }

    @Override
    public void setResourceTypeIdForGroup(long resourceGroupId, long resourceTypeId) {
        this.resourceTypeIdCache.add((Serializable)new Long(resourceGroupId), (Object)new Long(resourceTypeId));
    }

    @Override
    public Long getResourceTypeIdForResource(long resourceId) {
        Long resourceTypeId = null;
        IHibernatePersistenceService persistenceService = this.getPersistenceService();
        DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
        ResourceDAI dao = factory.getResourceDAO();
        Session currentSession = persistenceService.getCurrentSession();
        persistenceService.beginTransaction(currentSession);
        try {
            resourceTypeId = dao.findResourceTypeIDByKey(resourceId);
            persistenceService.commitTransaction(currentSession);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(currentSession);
            throw ex;
        }
        return resourceTypeId;
    }

    @Override
    public Long getResourceTypeIdForResourceName(String resourceName) {
        Long resourceTypeId = null;
        IHibernatePersistenceService persistenceService = this.getPersistenceService();
        DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
        ResourceDAI dao = factory.getResourceDAO();
        Session currentSession = persistenceService.getCurrentSession();
        persistenceService.beginTransaction(currentSession);
        try {
            resourceTypeId = dao.findResourceTypeByResourceName(resourceName);
            persistenceService.commitTransaction(currentSession);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(currentSession);
            throw ex;
        }
        return resourceTypeId;
    }

    @Override
    public Long getResourceTypeIdForDevice(String systemId) {
        Long resourceTypeId = null;
        IHibernatePersistenceService persistenceService = this.getPersistenceService();
        DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
        ResourceTypeDAI dao = factory.getResourceTypeDAO();
        Session currentSession = persistenceService.getCurrentSession();
        persistenceService.beginTransaction(currentSession);
        try {
            resourceTypeId = dao.findIDBySystemID(systemId);
            persistenceService.commitTransaction(currentSession);
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(currentSession);
            throw ex;
        }
        return resourceTypeId;
    }

    @Override
    public void start() {
        this.resourceTypeIdCache = new CacheService(RESOURCE_TYPE_ID_CACHE, Integer.MAX_VALUE);
        this.resourceTypeIdCache.start();
    }

    @Override
    public void stop() {
        this.resourceTypeIdCache.stop();
        this.resourceTypeIdCache = null;
    }

    private ICacheService<ResourceContainer> getResourceCache() {
        return (ICacheService)this.getService("ResourceContainerCache");
    }

    private IHibernatePersistenceService getPersistenceService() {
        return (IHibernatePersistenceService)this.getRegistry().lookup(IHibernatePersistenceService.class);
    }
}

