/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.event.ResourceOfflineEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceOnlineEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import org.apache.log4j.Logger;

public final class ResourceStateManager
extends ResourceManagementService {
    private static final Logger LOGGER = Logger.getLogger(ResourceStateManager.class);

    public boolean initializeResource(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = (Resource)container.getEntity();
        ResourceState opState = resource.getOperationalState();
        ResourceState adminState = resource.getAdministrationState();
        if (!(ResourceState.ONLINE != adminState && resource.getUserCount() <= 0 || ResourceState.OFFLINE != opState && ResourceState.HEARTBEAT_ERROR != opState)) {
            this.logStateChange(resource, ResourceState.INITIALIZING);
            resource.setOperationalState(ResourceState.INITIALIZING);
            stateChanged = true;
            if (container.getInitializationStrategy() != null) {
                container.getInitializationStrategy().initializeResource();
            } else {
                this.completeInitialization(container);
            }
        }
        return stateChanged;
    }

    private boolean completeInitialization(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = (Resource)container.getEntity();
        if (container.getInitializationStrategy() != null) {
            container.getInitializationStrategy().stopInitializingResource();
        }
        if (ResourceState.INITIALIZING == resource.getOperationalState()) {
            this.logStateChange(resource, ResourceState.ONLINE);
            resource.setOperationalState(ResourceState.ONLINE);
            stateChanged = true;
            if (container.getHeartBeatStrategy() != null) {
                container.getHeartBeatStrategy().startHeartBeatMonitor();
            }
            this.getDistributedEventHandler().handleEvent(new ResourceOnlineEvent(resource.getId(), resource.getResourceType().getId()));
        }
        return stateChanged;
    }

    public boolean tryTakeResourceOffline(ResourceContainer container) {
        boolean stateChanged = false;
        Resource resource = (Resource)container.getEntity();
        if (ResourceState.OFFLINE == resource.getAdministrationState() && ResourceState.OFFLINE != resource.getOperationalState() && ResourceState.INACTIVE != resource.getOperationalState() && ResourceState.INVALID != resource.getOperationalState() && resource.getUserCount() == 0) {
            stateChanged = this.takeResourceOffline(container);
        }
        return stateChanged;
    }

    private boolean takeResourceOffline(ResourceContainer container) {
        Resource resource = (Resource)container.getEntity();
        if (container.getInitializationStrategy() != null && container.getInitializationStrategy().isInitializing()) {
            container.getInitializationStrategy().stopInitializingResource();
        }
        if (container.getHeartBeatStrategy() != null && container.getHeartBeatStrategy().isMonitoringHeartBeats()) {
            container.getHeartBeatStrategy().stopHeartBeatMonitor();
        }
        this.logStateChange(resource, ResourceState.OFFLINE);
        resource.setOperationalState(ResourceState.OFFLINE);
        this.getDistributedEventHandler().handleEvent(new ResourceOfflineEvent(resource.getId(), resource.getResourceType().getId()));
        return true;
    }

    public boolean handleInitializationSuccess(ResourceContainer container) {
        boolean stateChanged = false;
        if (container != null) {
            stateChanged = this.completeInitialization(container);
        }
        return stateChanged;
    }

    public boolean handleInitializationFailure(ResourceContainer container) {
        boolean stateChanged = false;
        if (container != null) {
            Resource resource;
            if (container.getInitializationStrategy() != null) {
                container.getInitializationStrategy().stopInitializingResource();
            }
            if (ResourceState.INITIALIZING == (resource = (Resource)container.getEntity()).getOperationalState()) {
                this.logStateChange(resource, ResourceState.INITIALIZATION_ERROR);
                resource.setOperationalState(ResourceState.INITIALIZATION_ERROR);
                stateChanged = true;
            }
        }
        return stateChanged;
    }

    public boolean handleHeartBeatSuccess(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && ResourceState.HEARTBEAT_ERROR == (resource = (Resource)container.getEntity()).getOperationalState()) {
            if (container.getHeartBeatStrategy() != null && container.getHeartBeatStrategy().isMonitoringHeartBeats()) {
                container.getHeartBeatStrategy().stopHeartBeatMonitor();
            }
            stateChanged = this.initializeResource(container);
        }
        return stateChanged;
    }

    public boolean handleHeartBeatFailure(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && ResourceState.ONLINE == (resource = (Resource)container.getEntity()).getOperationalState()) {
            this.logStateChange(resource, ResourceState.HEARTBEAT_ERROR);
            resource.setOperationalState(ResourceState.HEARTBEAT_ERROR);
            stateChanged = true;
        }
        return stateChanged;
    }

    public boolean failResource(ResourceContainer container) {
        Resource resource;
        boolean stateChanged = false;
        if (container != null && (resource = (Resource)container.getEntity()).getOperationalState() != ResourceState.OFFLINE) {
            this.logStateChange(resource, ResourceState.ERROR);
            resource.setOperationalState(ResourceState.ERROR);
            stateChanged = true;
        }
        return stateChanged;
    }

    private void logStateChange(Resource resource, ResourceState newState) {
        if (resource.getOperationalState() == newState) {
            return;
        }
        LOGGER.info((Object)("Resource " + resource + ": " + resource.getOperationalState().getStateName() + " -> " + newState.getStateName()));
    }

    private IEventHandler getDistributedEventHandler() {
        return (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
    }
}

