/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.IExecutorService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.core.service.concurrent.MultiFuture;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.core.service.thread.IDistributedSchedulerService;
import com.tandbergtv.workflow.core.service.util.SchedulerUtils;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class DistributedScheduler<T>
implements IDistributedSchedulerService<T> {
    private final String name;
    private final int size;
    private IExecutorService executor;
    private IClusterService clusterService;

    public DistributedScheduler(String name) {
        this(name, 1);
    }

    public DistributedScheduler(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public Future<T> schedule(Callable<T> callable) {
        if (this.executor == null) {
            throw new IllegalStateException("Scheduler " + this.name + " has not started");
        }
        return SchedulerUtils.submitTask(callable, this.getExecutor(), this.getClusterService());
    }

    @Override
    public Future<Collection<T>> scheduleMulti(Callable<T> callable) {
        if (this.executor == null) {
            throw new IllegalStateException("Scheduler " + this.name + " has not started");
        }
        return new MultiFuture(this.executor.submitToAllMembers(callable).values());
    }

    @Override
    public void guessSchedule(Callable<T> callable) {
        if (callable instanceof DistributedCallable && ((DistributedCallable)callable).getKey() == null) {
            this.scheduleMulti(callable);
            return;
        }
        this.schedule(callable);
    }

    @Override
    public void start() {
        ExecutorConfig ec = new ExecutorConfig(this.name, this.size);
        this.getClusterService().getInstance().getConfig().addExecutorConfig(ec);
        this.executor = this.getClusterService().getInstance().getExecutorService(this.name);
    }

    @Override
    public void stop() {
        this.executor = null;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public Future<?> schedule(Runnable runnable, long delay, long period) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<T> schedule(Callable<T> callable, long delay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purge() {
    }

    @Override
    public int count() {
        return 0;
    }

    protected IExecutorService getExecutor() {
        return this.executor;
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }
}

