/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class DistributedCache<T>
implements IDistributedCache<T> {
    private static final Logger LOGGER = Logger.getLogger(DistributedCache.class);
    private String name;
    private int size;
    private IMap<Serializable, T> map;
    private IClusterService clusterService;
    private IMediator mediator;

    public DistributedCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public DistributedCache(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
        MapConfig config = new MapConfig(this.name);
        config.getMaxSizeConfig().setSize(this.size);
        config.setEvictionPolicy(EvictionPolicy.LRU);
        this.getClusterService().getInstance().getConfig().addMapConfig(config);
        this.map = this.getClusterService().getInstance().getMap(this.name);
        this.registerMigrationListener();
    }

    @Override
    public void stop() {
    }

    @Override
    public T get(Serializable key) {
        return (T)this.map.get((Object)key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void add(Serializable key, T entity) {
        if (key == null || entity == null) {
            throw new IllegalArgumentException();
        }
        this.map.put((Object)key, entity);
    }

    @Override
    public void remove(Serializable key) {
        this.map.remove((Object)key);
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public Collection<Serializable> localKeySet() {
        return this.map.localKeySet();
    }

    @Override
    public ConcurrentMap<Serializable, T> getMap() {
        return this.map;
    }

    protected void registerMigrationListener() {
        this.getClusterService().getInstance().getPartitionService().addMigrationListener(this.getMigrationListener());
    }

    protected MigrationListener getMigrationListener() {
        return new CacheKeyMigrationListener(this);
    }

    protected Set<Serializable> getLocalKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.localKeySet()) {
            if (this.getClusterService().getPartitionId((Object)key) != partitionId) continue;
            set.add(key);
        }
        return set;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected IMediator getMediator() {
        if (this.mediator == null) {
            this.mediator = DefaultMediator.getInstance();
        }
        return this.mediator;
    }

    protected void setMediator(IMediator mediator) {
        this.mediator = mediator;
    }

    protected class CacheKeyMigrationListener
    implements MigrationListener {
        protected final IDistributedCache<T> cache;

        public CacheKeyMigrationListener(IDistributedCache<T> cache) {
            this.cache = cache;
        }

        public void migrationStarted(MigrationEvent event) {
            if (this.wasPreviousOwner(event)) {
                Set<Serializable> set = Collections.emptySet();
                this.sendEvent(new PartitionEvent(this.cache, event, set, false));
            }
        }

        public void migrationCompleted(MigrationEvent event) {
            if (this.isNewOwner(event)) {
                Set<Serializable> set = DistributedCache.this.getLocalKeysInPartition(event.getPartitionId());
                boolean ownerAlive = DistributedCache.this.getClusterService().isMember(event.getOldOwner());
                if (!set.isEmpty()) {
                    this.sendEvent(new PartitionEvent(this.cache, event, set, true, ownerAlive));
                }
            }
        }

        public void migrationFailed(MigrationEvent migrationEvent) {
            LOGGER.warn((Object)("migration fail: " + migrationEvent.toString()));
        }

        protected void sendEvent(WorkflowEvent event) {
            DistributedCache.this.getMediator().sendAsync(event);
        }

        protected boolean wasPreviousOwner(MigrationEvent me) {
            return DistributedCache.this.getClusterService().getLocalMember().equals(me.getOldOwner());
        }

        protected boolean isNewOwner(MigrationEvent me) {
            return DistributedCache.this.getClusterService().getLocalMember().equals(me.getNewOwner());
        }
    }
}

