/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.watch.FileReader;
import com.tandbergtv.workflow.driver.template.watch.PackagedFileReader;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jbpm.graph.def.GraphElement;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class TemplateTest {
    private Long idToBeDeleted;

    @Test
    void service() {
        Assert.assertNotNull((Object)this.getService(ITemplateLoaderService.class));
    }

    private ITemplateLoaderService getService() {
        return this.getService(ITemplateLoaderService.class);
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    @Test(dependsOnMethods={"service"})
    void testPAR() throws Exception {
        this.createPar(new File("resources/Echo.par"));
        Thread.sleep(120000L);
        WorkflowTemplate newTemplate = this.getService().getTemplateByName("Echo");
        Assert.assertNotNull((Object)newTemplate);
        this.idToBeDeleted = newTemplate.getId();
    }

    private void createPar(File par) throws InterruptedException {
        this.getService().runCompiler(par, (ITemplateReader)new PackagedFileReader(par));
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
    }

    @Test(dependsOnMethods={"testPAR"})
    void testVersionForPar() {
        Assert.assertEquals((int)29, (int)this.getService().getTemplateByName("Echo").getVersion());
    }

    @Test(dependsOnMethods={"service"})
    void testXml() throws Exception {
        this.createXml(new File("resources/processdefinition.xml"));
        Assert.assertNotNull((Object)this.getService().getTemplateByName("Echo2"));
    }

    private void createXml(File xml) throws InterruptedException {
        this.getService().runCompiler(xml, (ITemplateReader)new FileReader(xml));
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
    }

    @Test(dependsOnMethods={"testXml"})
    void testVersionForXml() {
        Assert.assertEquals((int)21, (int)this.getService().getTemplateByName("Echo2").getVersion());
    }

    @Test(dependsOnMethods={"service"})
    void testGetLatestTemplates() throws Exception {
        List latestTemplates = this.getService().getLatestTemplates();
        WorkflowTemplate template = new WorkflowTemplate();
        this.setId(template, 3L);
        Assert.assertEquals((boolean)latestTemplates.contains(template), (boolean)true);
    }

    private void setId(WorkflowTemplate template, Long id) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = GraphElement.class.getDeclaredField("id");
        field.setAccessible(true);
        field.set(template, id);
    }

    void testGetAllTemplateNames() {
        List names = this.getService().getAllTemplateNames();
        Assert.assertEquals((boolean)names.contains("Asset Ingest - v48"), (boolean)true);
    }

    void testGetTemplate() throws DriverException {
        WorkflowTemplate template = this.getService().getTemplate((Serializable)Long.valueOf(3L));
        Assert.assertEquals((String)template.getName(), (String)"Asset Ingest");
    }

    void testGetTemplateByFullName() {
        Assert.assertNotNull((Object)this.getService().getTemplateByFullName("Asset Ingest - v48"));
    }

    void testGetTemplateByName() {
        Assert.assertNotNull((Object)this.getService().getTemplateByName("Asset Ingest"));
    }

    @Test(dependsOnMethods={"testDeletionOfOldTemplates"})
    void testDelete() throws Exception {
        WorkflowTemplate template = this.getService().getTemplate((Serializable)this.idToBeDeleted);
        Assert.assertNotNull((Object)template);
        this.getService().delete(template);
        Assert.assertNull((Object)this.getService().getTemplate((Serializable)this.idToBeDeleted));
    }

    @Test(dependsOnMethods={"testVersionForPar"})
    void testDeletionOfOldTemplates() throws Exception {
        WorkflowTemplate template = this.getService().getTemplateByName("Echo");
        Assert.assertNotNull((Object)template);
        Assert.assertTrue((boolean)this.getService().getPreviousVersions(template).isEmpty());
    }

    @Test(dependsOnMethods={"service"})
    void testAddSelector() throws Exception {
        WorkflowTemplate template = this.getService(ITemplateLoaderService.class).getTemplate((Serializable)Long.valueOf(3L));
        Selector selector = new Selector("020102", template);
        template.addSelectorKey(selector);
        this.getService(ITemplateLoaderService.class).update(template);
        Assert.assertNotNull((Object)this.getService(ITemplateLoaderService.class).getTemplateBySelectorKey("020102"));
    }

    @Test(dependsOnMethods={"testAddSelector"})
    void testRemoveSelector() throws DriverException {
        WorkflowTemplate template = this.getService(ITemplateLoaderService.class).getTemplate((Serializable)Long.valueOf(3L));
        Selector selector = new Selector("020102", template);
        template.removeSelectorKey(selector);
        this.getService(ITemplateLoaderService.class).update(template);
        try {
            this.getService(ITemplateLoaderService.class).getTemplateBySelectorKey("020102");
            Assert.assertTrue((boolean)false);
        }
        catch (DriverRuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

