/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.watch.FileReader;
import com.tandbergtv.workflow.driver.template.watch.PackagedFileReader;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TestUtil {
    public static void deploy(File par) throws InterruptedException {
        TestUtil.deploy(par, 0L);
    }

    public static void deploy(File par, long sleep) throws InterruptedException {
        TestUtil.getService(ITemplateLoaderService.class).runCompiler(par, (ITemplateReader)new PackagedFileReader(par));
        Thread.sleep(TimeUnit.SECONDS.toMillis(sleep));
    }

    public static void deployXml(File xml) throws InterruptedException {
        TestUtil.getService(ITemplateLoaderService.class).runCompiler(xml, (ITemplateReader)new FileReader(xml));
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    public static ResourceManagement getResourceManagement() {
        return (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
    }

    public static WorkflowLogService getWorkflowLogService() {
        return (WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class);
    }

    public static void start() {
        Platform.getPlatform().start("workflow.xml");
    }

    public static void stop() {
        IProcessManagerService pm = (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        pm.stop();
        Platform.getPlatform().stop("workflow.xml");
    }

    public static void restart() {
        TestUtil.stop();
        TestUtil.start();
        try {
            TimeUnit.MINUTES.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void restartBootstrapAsync() throws IOException {
        File restartMessageFile = new File(System.getProperty("com.tandbergtv.cms.product.dir") + "/restart");
        restartMessageFile.createNewFile();
    }
}

