/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.rest.services.internal.ResourcesResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class ResourcesResourceTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/resources/";
    private static final String NAME_API_PATH = "/resources/name/";
    private static final String PREFIX = "ResourcesREST_";
    private static final String RESOURCE_TYPE_SYSTEM_ID = "27";
    private static final String ResourceGroupFieldName = "resourceGroups";
    private static final String CONNECTION_STRING_BASE = "http://localhost:8080/";
    private static final long HEARTBEAT_FREQUENCY = 10L;
    private static final boolean IGNORE_TIMEOUT = false;

    public ResourcesResourceTest() {
        super(ResourcesResource.class);
    }

    @AfterTest
    public void cleanupResources() throws ResourceManagementException {
        ResourceUtils.deleteResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, PREFIX);
    }

    @Test
    public void testResourceNameGet() throws Exception {
        Resource resource = this.initializeResource();
        String uri = NAME_API_PATH + resource.getName();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesResourceTest.assertEquals((int)response.getStatus(), (int)200);
        List<Map<String, Object>> variablesListMap = RESTUtil.getComplexFieldValues(response.getContentAsString(), ResourceGroupFieldName);
        this.verifyResponseParameters(RESTUtil.deserialize(response), variablesListMap, resource, uri);
    }

    @Test
    public void testResourceIdGet() throws Exception {
        Resource resource = this.initializeResource();
        String uri = BASE_API_PATH + resource.getId();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesResourceTest.assertEquals((int)response.getStatus(), (int)200);
        List<Map<String, Object>> variablesListMap = RESTUtil.getComplexFieldValues(response.getContentAsString(), ResourceGroupFieldName);
        this.verifyResponseParameters(RESTUtil.deserialize(response), variablesListMap, resource, uri);
    }

    private Resource initializeResource() throws DataOperationException, ValidationException {
        String uniqueName = PREFIX + System.currentTimeMillis();
        String connectionString = CONNECTION_STRING_BASE + uniqueName;
        Resource resource = ResourceUtils.createResource(ResourceUtils.getResourceBuilderFromSystemId(RESOURCE_TYPE_SYSTEM_ID, PREFIX).name(uniqueName).connectionString(connectionString).heartbeatConnectionString(connectionString).heartbeatFrequency(10L).ignoreTimeout(false));
        return resource;
    }

    private void verifyResponseParameters(Map<String, Object> responseMap, List<Map<String, Object>> resourceGroupsFromResponse, Resource resource, String path) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        resource = ResourceUtils.getResource(resource.getId());
        ResourcesResourceTest.assertEquals((String)responseMap.get("id").toString(), (String)String.valueOf(resource.getId()));
        ResourcesResourceTest.assertEquals((String)responseMap.get("name").toString(), (String)resource.getName());
        ResourcesResourceTest.assertEquals((Object)responseMap.get("href"), (Object)("http://localhost:8081/resources/" + resource.getId()));
        ResourcesResourceTest.assertEquals((String)responseMap.get("userCount").toString(), (String)String.valueOf(ResourceUtils.getResourceUserCount(resource.getId())));
        ResourcesResourceTest.assertEquals((String)responseMap.get("adminState").toString(), (String)resource.getAdministrationState().toString());
        ResourcesResourceTest.assertEquals((String)responseMap.get("operationalState").toString(), (String)resource.getOperationalState().toString());
        ResourcesResourceTest.assertEquals((String)responseMap.get("resourceTypeName").toString(), (String)resource.getResourceType().getName());
        ResourcesResourceTest.assertEquals((String)responseMap.get("connectionString").toString(), (String)resource.getConnectionString());
        ResourcesResourceTest.assertEquals((String)responseMap.get("maxConcurrentUsage").toString(), (String)String.valueOf(resource.getMaxConcurrentUsers()));
        ResourcesResourceTest.assertEquals((String)responseMap.get("ignoreTimeOut").toString(), (String)String.valueOf(resource.getIgnoreTimeout()));
        this.verifyResourceGroups(resourceGroupsFromResponse, this.buildExpectedResourceGroups(resource.getResourceGroups(), path));
    }

    private List<Map<String, String>> buildExpectedResourceGroups(Set<ResourceGroup> resourceGroups, String resourcePath) {
        ArrayList<Map<String, String>> stringsList = new ArrayList<Map<String, String>>();
        for (ResourceGroup group : resourceGroups) {
            HashMap<String, String> strings = new HashMap<String, String>();
            strings.put("id", String.valueOf(group.getId()));
            strings.put("name", group.getName());
            strings.put("href", "http://localhost:8081/resourceGroups/" + group.getId());
            strings.put("queueSize", String.valueOf(group.getQueue().size()));
            stringsList.add(strings);
        }
        return stringsList;
    }

    private void verifyResourceGroups(List<Map<String, Object>> responseGroups, List<Map<String, String>> expectedGroups) throws JsonParseException, JsonMappingException, IOException {
        for (Map<String, String> expected : expectedGroups) {
            boolean foundMatch = false;
            for (Map<String, Object> response : responseGroups) {
                if (!expected.get("id").equals(response.get("id").toString())) continue;
                foundMatch = true;
                ResourcesResourceTest.assertEquals((String)expected.get("name"), (String)response.get("name").toString());
                ResourcesResourceTest.assertEquals((String)expected.get("href"), (String)response.get("href").toString());
                ResourcesResourceTest.assertEquals((String)expected.get("queueSize"), (String)response.get("queueSize").toString());
            }
            if (foundMatch) continue;
            ResourcesResourceTest.fail((String)("The Response was missing a resourceGroup entry for resource group id: " + expected.get("id")));
        }
    }
}

