/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.search;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchTest
extends NormalTestBase {
    private static final String START_TIME = "startTime";
    private static final String START_DATE = "2001-01-01";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private Set<WorkflowProcess> set = new HashSet<WorkflowProcess>();
    private String uuid = "";

    @AfterClass
    void teardown() throws Exception {
        IProcessManagerService service = ProcessUtils.getProcessManager();
        for (WorkflowProcess p : this.set) {
            service.delete(p);
        }
        this.uuid = "";
    }

    @BeforeClass
    void setup() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.uuid = UUID.randomUUID().toString();
        params.put("titleBrief", this.uuid);
        WorkflowProcess wp = this.run("search-workorder-template", params);
        SearchTest.assertNotNull((Object)wp);
        Thread.sleep(10000L);
        ProcessUtils.sleepUntilComplete(wp.getId(), 300000L);
        this.set.add(wp);
    }

    @Test
    void testSearchStartDateNoEndDate() {
        SearchCriteria c = this.defaultCriteria();
        SearchTest.assertEquals((int)this.count(this.setDate(c, this.today(), "")), (int)1);
    }

    @Test
    void testSearchEndDateNoStartDate() {
        SearchCriteria c = this.defaultCriteria();
        SearchTest.assertEquals((int)this.count(this.setDate(c, "", this.today())), (int)1);
    }

    @Test
    void testSearchBothStartEndDate() {
        SearchCriteria c = this.defaultCriteria();
        SearchTest.assertEquals((int)this.count(this.setDate(c, START_DATE, this.today())), (int)1);
    }

    @Test
    void testSearchWithNoCriteria() {
        SearchCriteria c = this.defaultCriteria();
        SearchTest.assertEquals((int)this.count(this.setDate(c, "", "")), (int)1);
    }

    @Test
    void testSearchByProcessID() {
        SearchCriteria c = new SearchCriteria();
        c.addParameter((SearchParameterBase)new ValueParameter("id", SearchType.NUMERIC, true, (Object)this.getProcessID(), SearchOperator.EQUAL));
        SearchTest.assertEquals((int)this.count(c), (int)1);
    }

    long getProcessID() {
        return this.set.iterator().next().getId();
    }

    int count(SearchCriteria criteria) {
        return this.getService().expressCount(criteria);
    }

    SearchCriteria defaultCriteria() {
        SearchCriteria c = new SearchCriteria();
        c.addParameter((SearchParameterBase)new ValueParameter("titleBrief", SearchType.STRING, true, (Object)this.uuid, SearchOperator.EQUAL));
        c.addParameter((SearchParameterBase)new ValueParameter("all"));
        return c;
    }

    SearchCriteria setDate(SearchCriteria c, String startDate, String endDate) {
        RangeParameter rangeParam;
        if (!startDate.equals("")) {
            rangeParam = new RangeParameter(START_TIME, SearchType.DATE, false);
            rangeParam.setFrom(startDate);
            c.addParameter((SearchParameterBase)rangeParam);
        }
        if (!endDate.equals("")) {
            rangeParam = new RangeParameter(START_TIME, SearchType.DATE, false);
            rangeParam.setTo(endDate);
            c.addParameter((SearchParameterBase)rangeParam);
        }
        return c;
    }

    String today() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    IProcessSearchService getService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }
}

