/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.simulator;

import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.adaptor.messageidentifier.WPCLMessageIdentifier;
import com.tandbergtv.workflow.adaptor.simulator.SimulatorConfiguration;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Simulator
implements IAdaptor {
    private List<IMessageIdentifier> messageIDClasses = new ArrayList<IMessageIdentifier>();
    private static final Logger LOGGER = Logger.getLogger(Simulator.class);

    private Simulator() {
        this.messageIDClasses.add(new WPCLMessageIdentifier());
    }

    @Override
    public boolean canDeliver(IAdaptorRequest request) {
        try {
            if (request == null || request.getMessage() == null) {
                return false;
            }
            IMessageUID uid = this.getMessageUID(request.getMessage());
            if (uid == null) {
                return false;
            }
            SimulatorConfiguration simulatorConfig = SimulatorConfiguration.newInstance();
            HashMap<String, WorkflowMessage> simulatedMessages = simulatorConfig.getMessages();
            Iterator<Map.Entry<String, WorkflowMessage>> i$ = simulatedMessages.entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<String, WorkflowMessage> entry = i$.next();
                WorkflowMessage msg = entry.getValue();
                return msg.getMessageUID().equals(uid);
            }
        }
        catch (Exception e) {
            String msg = "Failure when determining if simulator can deliver message " + this.getMessageUID(request.getMessage()).getUID();
            LOGGER.debug((Object)msg, (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public void init(IAdaptorConfiguration conf) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public IAdaptorResponse transmit(IAdaptorRequest request) {
        return null;
    }

    protected IMessageUID getMessageUID(IMessage message) {
        for (IMessageIdentifier identifier : this.messageIDClasses) {
            IMessageUID uid = null;
            try {
                uid = identifier.identify(message);
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Class " + identifier.getClass().getName() + " failed to determine message uid"), (Throwable)ex);
            }
            if (uid == null) continue;
            return uid;
        }
        return null;
    }
}

