/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.email.IEmailService;
import com.tandbergtv.workflow.settings.NeptuneSettingsCache;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class SimpleEmailService
implements IEmailService,
EntryListener<Serializable, String> {
    private static final Logger LOGGER = Logger.getLogger(SimpleEmailService.class);
    private volatile Session session;
    private NeptuneSettingsCache neptuneSettingsCache;
    private ObjectMapper objectMapper;

    public String getServiceName() {
        return SimpleEmailService.class.getName();
    }

    public void start() {
        if (this.getNeptuneSettingsCache() == null || this.getNeptuneSettingsCache().getMap() == null) {
            throw new IllegalStateException("NeptuneSettingsCache is not ready");
        }
        ((IMap)this.getNeptuneSettingsCache().getMap()).addEntryListener((EntryListener)this, true);
        LOGGER.info((Object)"SimpleEmailService started");
        try {
            if (this.session == null) {
                this.doLoadSession((String)this.getNeptuneSettingsCache().get((Serializable)((Object)"com.ericsson.cms.email")), null);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("cannot get email settings now: " + e.getLocalizedMessage()));
        }
    }

    public void stop() {
        if (this.getNeptuneSettingsCache() == null || this.getNeptuneSettingsCache().getMap() == null) {
            throw new IllegalStateException("NeptuneSettingsCache is not ready");
        }
        ((IMap)this.getNeptuneSettingsCache().getMap()).removeEntryListener((EntryListener)this);
        LOGGER.info((Object)"SimpleEmailService stopped");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void send(Address[] recipients, String subject, String content) throws MessagingException {
        Session s = this.session;
        if (s == null) {
            throw new MessagingException("no mail session available yet, could be this service is not started yet or the email settings in Neptune is removed.");
        }
        MimeMessage message = new MimeMessage(s);
        message.setFrom();
        message.setRecipients(MimeMessage.RecipientType.TO, recipients);
        message.setSubject(subject);
        message.setText(content);
        this.sendMessage((Message)message);
    }

    protected void sendMessage(Message message) throws MessagingException {
        Transport.send((Message)message);
    }

    public void entryAdded(EntryEvent<Serializable, String> event) {
        this.reloadSession(event);
    }

    public void entryRemoved(EntryEvent<Serializable, String> event) {
        this.cleanSession(event);
    }

    public void entryUpdated(EntryEvent<Serializable, String> event) {
        this.reloadSession(event);
    }

    public void entryEvicted(EntryEvent<Serializable, String> event) {
        this.cleanSession(event);
    }

    private void reloadSession(EntryEvent<Serializable, String> event) {
        if (!StringUtils.equals((String)String.valueOf(event.getKey()), (String)"com.ericsson.cms.email")) {
            return;
        }
        this.doLoadSession((String)event.getValue(), (String)event.getOldValue());
    }

    private void doLoadSession(String setting, String oldSetting) {
        try {
            LOGGER.info((Object)("loading email session with setting[" + setting + "]"));
            Map settings = (Map)this.getObjectMapper().readValue(setting, Map.class);
            Properties props = new Properties();
            props.put("mail.smtp.host", settings.get("mail_smtp_host"));
            props.put("mail.smtp.port", (Object)Integer.parseInt((String)settings.get("mail_smtp_port")));
            props.put("mail.from", settings.get("mail_from"));
            this.session = Session.getInstance((Properties)props);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("cannot read neptune email settings, old setting value will be used[" + oldSetting + "], error: " + e.getLocalizedMessage()));
        }
    }

    private void cleanSession(EntryEvent<Serializable, String> event) {
        if (!StringUtils.equals((String)String.valueOf(event.getKey()), (String)"com.ericsson.cms.email")) {
            return;
        }
        this.session = null;
    }

    private NeptuneSettingsCache getNeptuneSettingsCache() {
        if (this.neptuneSettingsCache == null) {
            this.neptuneSettingsCache = (NeptuneSettingsCache)ServiceRegistry.getDefault().lookup("WFS:NeptuneSettingsCache");
        }
        return this.neptuneSettingsCache;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void setNeptuneSettingsCache(NeptuneSettingsCache neptuneSettingsCache) {
        this.neptuneSettingsCache = neptuneSettingsCache;
    }
}

