/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.driver.template.ExtendedJpdlXmlReader;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public abstract class AbstractTemplateReader
implements ITemplateReader {
    protected File file;
    private static final String PLUGIN = "com.tandbergtv.workflow";
    private static final String EXTENSION_POINT = "parser";
    private static final Logger LOGGER = Logger.getLogger(AbstractTemplateReader.class);

    protected AbstractTemplateReader(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected Collection<ExtendedJpdlXmlReader> getReaderExtensions() {
        ArrayList<ExtendedJpdlXmlReader> extensions = new ArrayList<ExtendedJpdlXmlReader>();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        PluginRegistry registry = pm.getRegistry();
        try {
            ExtensionPoint ep = registry.getExtensionPoint(PLUGIN, EXTENSION_POINT);
            for (Extension e : ep.getAvailableExtensions()) {
                try {
                    ExtendedJpdlXmlReader reader = this.loadParser(pm, e);
                    LOGGER.info((Object)("Created parser " + reader.getClass().getName()));
                    extensions.add(reader);
                }
                catch (Exception e1) {
                    LOGGER.warn((Object)("Cannot load parser extension " + e.getDeclaringPluginDescriptor().getId()), (Throwable)e1);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)"Old com.tandbergtv.workflow plugin.xml, please update");
        }
        return extensions;
    }

    protected ExtendedJpdlXmlReader loadParser(PluginManager pm, Extension e) throws Exception {
        PluginDescriptor plugin = e.getDeclaringPluginDescriptor();
        pm.activatePlugin(plugin.getId());
        PluginClassLoader loader = pm.getPluginClassLoader(plugin);
        Class<?> clazz = loader.loadClass(e.getParameter("class").valueAsString());
        return (ExtendedJpdlXmlReader)clazz.newInstance();
    }

    public WorkflowTemplate read() {
        WorkflowTemplate template = null;
        ExtendedJpdlXmlReader reader = null;
        try {
            InputStream is = this.getInputStream();
            reader = new ExtendedJpdlXmlReader(is);
            for (ExtendedJpdlXmlReader extension : this.getReaderExtensions()) {
                reader.addExtension(extension);
            }
            template = (WorkflowTemplate)reader.readProcessDefinition();
        }
        catch (TemplateReaderException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TemplateReaderException("Template file does not exist", (Throwable)e);
        }
        catch (Exception e) {
            throw new TemplateReaderException("Failed to read template ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return template;
    }
}

