/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.LogDeserializer;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.file.FileLogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class LogReader {
    private static final Logger LOGGER = Logger.getLogger(LogReader.class);
    private String root;
    private final TransportClient client;
    private static final TimeValue TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final String TYPE_LOG = "log";
    private static final String PROCESS_ID = "processId";
    private static final String LOG_TYPE = "logType";
    private static final String NODE_ID = "nodeId";
    private static final String LOG_ID = "id";

    public LogReader(String root, TransportClient client) {
        this.root = root;
        this.client = client;
    }

    public LogReader(TransportClient client) {
        this.client = client;
    }

    public int count(long id, final Class<? extends ProcessLog> type, Set<Long> nodeIds) {
        return this.count(id, (Collection<Class<? extends ProcessLog>>)new ArrayList<Class<? extends ProcessLog>>(){
            {
                this.add(type);
            }
        }, nodeIds);
    }

    public int count(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        try {
            SearchRequestBuilder bld = this.getSearchRequestBuilder(this.getBasicFilterCriteria(id, types, nodeIds));
            int count = (int)this.getSearchResponse(bld).getHits().totalHits();
            if (count == 0 && this.root != null) {
                return new FileLogReader(this.root).count(id, types, nodeIds);
            }
            return count;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return 0;
        }
    }

    public List<ProcessLog> getLogs(long id, final Class<? extends ProcessLog> type) {
        return this.getLogs(id, (Collection<Class<? extends ProcessLog>>)new ArrayList<Class<? extends ProcessLog>>(){
            {
                this.add(type);
            }
        });
    }

    public List<ProcessLog> getLogs(long id, final Class<? extends ProcessLog> type, Set<Long> nodeIds, int start, int count, boolean descending) {
        return this.getLogs(id, (Collection<Class<? extends ProcessLog>>)new ArrayList<Class<? extends ProcessLog>>(){
            {
                this.add(type);
            }
        }, nodeIds, start, count, descending);
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types) {
        try {
            AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]).add((FilterBuilder)FilterBuilders.termFilter((String)PROCESS_ID, (long)id)).add((FilterBuilder)FilterBuilders.inFilter((String)LOG_TYPE, (String[])LogReader.getLogTypes(types)));
            SearchRequestBuilder bld = this.getSearchRequestBuilder((FilterBuilder)filterBuilder);
            bld = this.setSortCrtieria(LOG_ID, false, bld);
            List<ProcessLog> logs = this.getProcessLogs(bld);
            if (logs.isEmpty() && this.root != null) {
                return new FileLogReader(this.root).getLogs(id, types);
            }
            return logs;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        try {
            SearchRequestBuilder bld = this.getSearchRequestBuilder(this.getBasicFilterCriteria(id, types, nodeIds));
            bld = this.setSortCrtieria(LOG_ID, descending, bld);
            bld.setFrom(start);
            bld.setSize(count);
            List<ProcessLog> logs = this.getProcessLogs(bld);
            if (logs.isEmpty() && this.root != null) {
                return new FileLogReader(this.root).getLogs(id, types, nodeIds, start, count, descending);
            }
            return logs;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static String[] getLogTypes(Collection<Class<? extends ProcessLog>> types) {
        ArrayList<String> logTypes = new ArrayList<String>();
        for (Class<? extends ProcessLog> log : types) {
            if (NodeLog.class.isAssignableFrom(log)) {
                logTypes.add("nodeLog");
                continue;
            }
            if (MessageLog.class.isAssignableFrom(log)) {
                logTypes.add("messageLog");
                continue;
            }
            if (!ProcessStatusPerResourceLog.class.isAssignableFrom(log)) continue;
            logTypes.add("resourceLog");
        }
        return logTypes.toArray(new String[logTypes.size()]);
    }

    private Object[] getNodeIds(Set<Long> nodeIds) {
        return nodeIds.toArray(new Long[nodeIds.size()]);
    }

    private SearchRequestBuilder getRequestBuilder() {
        return this.client.prepareSearch(new String[0]).setTypes(new String[]{TYPE_LOG});
    }

    private FilterBuilder getBasicFilterCriteria(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]).add((FilterBuilder)FilterBuilders.termFilter((String)PROCESS_ID, (long)id)).add((FilterBuilder)FilterBuilders.inFilter((String)LOG_TYPE, (String[])LogReader.getLogTypes(types))).add((FilterBuilder)FilterBuilders.inFilter((String)NODE_ID, (Object[])this.getNodeIds(nodeIds)));
        return filterBuilder;
    }

    private SearchRequestBuilder getSearchRequestBuilder(FilterBuilder filterBuilder) {
        SearchRequestBuilder bld = this.getRequestBuilder();
        bld.setPostFilter(filterBuilder);
        return bld;
    }

    private SearchRequestBuilder setSortCrtieria(String sortField, boolean descending, SearchRequestBuilder bld) {
        FieldSortBuilder sort = SortBuilders.fieldSort((String)sortField);
        sort.order(descending ? SortOrder.DESC : SortOrder.ASC);
        sort.unmappedType("long");
        return bld.addSort((SortBuilder)sort);
    }

    private List<ProcessLog> getProcessLogs(SearchRequestBuilder bld) {
        return LogDeserializer.convert(this.getSearchResponse(bld).getHits().getHits());
    }

    private SearchResponse getSearchResponse(SearchRequestBuilder bld) {
        long startTime = System.currentTimeMillis();
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(TIMEOUT);
        LOGGER.debug((Object)("actionGet: " + (System.currentTimeMillis() - startTime) + " ms."));
        return resp;
    }
}

