/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.google.common.base.Function;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class LogConverterService
implements Service {
    private Map<Class<?>, Function<ProcessLog, Map<String, Object>>> registry;

    public void start() {
        this.registry = new ConcurrentHashMap();
        this.register(NodeLog.class, new Function<NodeLog, Map<String, Object>>(){

            public Map<String, Object> apply(NodeLog log) {
                NodeLog nodeLog = log;
                ConcurrentHashMap<String, Object> logMap = new ConcurrentHashMap<String, Object>();
                logMap.put("logType", "nodeLog");
                logMap.put("id", nodeLog.getLeave().getTime());
                logMap.put("eventTimestamp", nodeLog.getLeave().getTime());
                logMap.put("tokenId", log.getToken().getId());
                logMap.put("nodeId", nodeLog.getNode().getId());
                logMap.put("startTime", nodeLog.getEnter().getTime());
                logMap.put("endTime", nodeLog.getLeave().getTime());
                return logMap;
            }
        });
        this.register(MessageLog.class, new Function<MessageLog, Map<String, Object>>(){

            public Map<String, Object> apply(MessageLog log) {
                WorkflowMessageLog wml = log.getLog();
                ConcurrentHashMap<String, Object> logMap = new ConcurrentHashMap<String, Object>();
                logMap.put("logType", "messageLog");
                logMap.put("id", wml.getTimestamp().getTime());
                logMap.put("eventTimestamp", wml.getTimestamp().getTime());
                logMap.put("tokenId", log.getToken().getId());
                logMap.put("nodeId", wml.getNode().getId());
                logMap.put("timestamp", wml.getTimestamp().getTime());
                logMap.put("incoming", wml.isIncoming());
                logMap.put("message", wml.getMessage());
                logMap.put("messageName", wml.getMessageName());
                logMap.put("messageType", wml.getMessageType());
                logMap.put("messageUID", wml.getMessageUID());
                Resource resource = wml.getResource();
                if (resource != null) {
                    logMap.put("resourceId", resource.getId());
                }
                return logMap;
            }
        });
        this.register(ProcessStatusPerResourceLog.class, new Function<ProcessStatusPerResourceLog, Map<String, Object>>(){

            public Map<String, Object> apply(ProcessStatusPerResourceLog log) {
                ProcessStatusPerResourceLog resourceLog = log;
                ConcurrentHashMap<String, Object> logMap = new ConcurrentHashMap<String, Object>();
                logMap.put("logType", "resourceLog");
                logMap.put("id", resourceLog.getEndTime().getTime());
                logMap.put("eventTimestamp", resourceLog.getEndTime().getTime());
                logMap.put("tokenId", log.getToken().getId());
                logMap.put("nodeId", resourceLog.getNodeId());
                logMap.put("startTime", resourceLog.getStartTime().getTime());
                logMap.put("endTime", resourceLog.getEndTime().getTime());
                logMap.put("resourceId", resourceLog.getResourceId());
                logMap.put("resourceGroupId", resourceLog.getResourceGroupId());
                logMap.put("queued", resourceLog.getOperationalStatus() == ProcessStatus.QUEUED);
                logMap.put("adminStatus", resourceLog.getAdminStatus());
                logMap.put("operationalStatus", resourceLog.getOperationalStatus());
                return logMap;
            }
        });
    }

    public void stop() {
    }

    public String getServiceName() {
        return "LogEventConverter";
    }

    public <T extends ProcessLog> void register(Class<T> clazz, Function<T, Map<String, Object>> function) {
        this.registry.put(clazz, function);
    }

    public <T extends ProcessLog> void deregister(Class<T> clazz) {
        this.registry.remove(clazz);
    }

    public <T extends ProcessLog> Map<String, Object> convert(Class<T> clazz, ProcessLog log) {
        Function<ProcessLog, Map<String, Object>> function = this.registry.get(clazz);
        return (Map)function.apply((Object)log);
    }
}

