/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.AbstractAction;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.util.ResourceFailureLogWriter;
import java.util.UUID;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public abstract class AbstractMessageHandler
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getResource(ExecutionContext context) {
        if (!this.needsResource(context)) {
            return this.autoGenerateResource();
        }
        ContextInstance c = context.getContextInstance();
        WorkflowProcess process = (WorkflowProcess)context.getProcessInstance();
        Resource resource = null;
        process.lock();
        try {
            resource = (Resource)c.getTransientVariable("_resource_" + context.getToken().getId());
        }
        finally {
            process.unlock();
        }
        if (resource == null) {
            throw new ActionException(context.getToken() + ", resource unavailable");
        }
        return resource;
    }

    protected boolean needsResource(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getCurrentNode();
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        IInternalResourceService service = (IInternalResourceService)ServiceRegistry.getDefault().lookup(IInternalResourceService.class);
        return service.needsResource(resourceGroupId.longValue()) && !Boolean.getBoolean("com.tandbergtv.workflow.resourcemanager.consumertrace.disable");
    }

    protected Resource autoGenerateResource() {
        Resource resource = new Resource();
        ResourceType rt = new ResourceType();
        rt.setConnectionType(ResourceConnectionType.URL);
        String name = UUID.randomUUID().toString();
        resource.setConnectionString("resource:///" + name);
        resource.setName(name);
        resource.setResourceType(rt);
        return resource;
    }

    protected void logResourceFailure(WorkflowMessage response, ExecutionContext context) {
        Long resourceGroupID;
        Resource resource = this.getResource(context);
        Token token = context.getToken();
        if ((response == null || response.getType() == WorkflowMessage.MessageType.nack) && (resourceGroupID = ((CustomToken)CustomToken.class.cast(token)).getResourceGroupID()) != null) {
            ResourceFailureLogWriter.getInstance().writeLog(resourceGroupID.longValue(), resource);
        }
    }
}

