/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.routing.impl;

import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Router
implements IRoutingService {
    private static final ThreadLocal<DocumentBuilder> BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };
    private static final ThreadLocal<Transformer> TRANSFORMER = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException e) {
                throw new Error();
            }
        }
    };
    private static Logger LOGGER = Logger.getLogger(Router.class);

    public IMessage send(IMessage message) throws CommunicationException {
        LOGGER.debug((Object)("Request " + message));
        MessageImpl ret = null;
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        try {
            WorkflowMessage request = this.toWorkflowMessage(message);
            WorkflowMessage response = executor.execute(request);
            LOGGER.debug((Object)("Response " + response));
            ret = this.toGenericMessage(response);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public WorkflowMessage send(WorkflowMessage message, List<IDestination> destinations) throws CommunicationException {
        if (destinations == null || destinations.isEmpty()) {
            throw new CommunicationException("At least one destination must be specified");
        }
        LOGGER.debug((Object)("Request " + message));
        WorkflowMessage ret = null;
        try {
            String deviceId = this.getMessageDeviceID(message);
            MessageImpl request = this.toGenericMessage(message);
            AdaptorRequestImpl adaptorRequest = new AdaptorRequestImpl((IMessage)request, message.getSource(), destinations);
            IAdaptorRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getRegistry();
            IAdaptor adaptor = registry.getDeviceAdaptor(deviceId);
            if (adaptor == null) {
                throw new CommunicationException("No adaptor registered for systemID[" + deviceId + "]");
            }
            IAdaptorResponse response = adaptor.transmit((IAdaptorRequest)adaptorRequest);
            ret = this.toWorkflowMessage(response.getMessage());
            LOGGER.debug((Object)("Response: " + ret));
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    private String getMessageDeviceID(WorkflowMessage message) throws CommunicationException {
        String deviceId = null;
        String uid = message.getMessageUID().getUID();
        IMessageRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
        deviceId = registry.getMessageDeviceID(uid);
        if (deviceId == null) {
            throw new CommunicationException("No message found in registry for UID[" + uid + "]");
        }
        return deviceId;
    }

    private WorkflowMessage toWorkflowMessage(IMessage msg) throws Exception {
        String xml = msg.getPayload().getContent();
        Document document = this.getDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
        String uidValue = message.getMessageUID().getUID();
        IMessageRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
        IMessageUID uid = registry.getMessageUID(uidValue);
        if (uid == null) {
            throw new CommunicationException("UID " + message.getMessageUID().getUID() + " not found in the message registry");
        }
        message.addAttachment(msg.getAttachment());
        return message;
    }

    private MessageImpl toGenericMessage(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringWriter w = new StringWriter();
        Transformer transformer = this.getTransformer();
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        transformer.transform(new DOMSource(document), new StreamResult(w));
        StringPayload payload = new StringPayload(w.getBuffer().toString());
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }

    private Transformer getTransformer() {
        Transformer transformer = TRANSFORMER.get();
        transformer.reset();
        return transformer;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = BUILDER.get();
        builder.reset();
        return builder;
    }
}

