/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.driver.boot.ILicenseProvider;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class LicenseProviderFactory {
    protected static final Logger LOGGER = Logger.getLogger(LicenseProviderFactory.class);
    private static final String LICENSE_PLUGIN = "com.tandbergtv.workflow.license";
    private static final String LICENSE_PROVIDER_EXTENSION_POINT = "licenseProvider";

    public static ILicenseProvider getLicenseProvider() {
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = null;
        try {
            point = pluginManager.getRegistry().getExtensionPoint(LICENSE_PLUGIN, LICENSE_PROVIDER_EXTENSION_POINT);
            if (point.getAvailableExtensions().isEmpty()) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error loading plugin: com.tandbergtv.workflow.license", (Throwable)e);
            return null;
        }
        Extension extension = (Extension)point.getAvailableExtensions().iterator().next();
        String className = extension.getParameter("class").valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        ILicenseProvider provider = null;
        try {
            provider = (ILicenseProvider)pluginManager.getPluginClassLoader(desc).loadClass(className).newInstance();
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Error loading license provider: " + className), (Throwable)e);
        }
        return provider;
    }
}

