/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEventLogger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ResourceEventHistoryRemover
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResourceEventHistoryRemover.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final int historyRetentionDays;

    public ResourceEventHistoryRemover(int historyRetentionDays) {
        this.historyRetentionDays = historyRetentionDays;
    }

    @Override
    public void run() {
        if (!Cluster.isMaster()) {
            return;
        }
        Calendar now = Calendar.getInstance();
        now.add(6, -this.historyRetentionDays);
        LOGGER.info((Object)("Deleting all resource event history from " + DATE_FORMAT.format(now.getTime()) + " and earlier."));
        ResourceHeartBeatEventLogger eventLogger = new ResourceHeartBeatEventLogger();
        File resoureHistoryDir = new File(eventLogger.getBaseResourceHistoryPath());
        if (!resoureHistoryDir.isDirectory()) {
            return;
        }
        File[] resourceDateDirs = resoureHistoryDir.listFiles();
        if (resourceDateDirs == null) {
            return;
        }
        for (int i = 0; i < resourceDateDirs.length; ++i) {
            File dir = resourceDateDirs[i];
            int dateStartIndex = dir.toString().lastIndexOf(File.separator) + 1;
            String dirDateStr = dir.toString().substring(dateStartIndex, dir.toString().length());
            try {
                Date resourceHistoryDirDate = DATE_FORMAT.parse(dirDateStr);
                if (!dir.isDirectory() || !resourceHistoryDirDate.before(now.getTime())) continue;
                LOGGER.info((Object)("Removing resource history folder " + dir));
                Directories.delete(dir);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Unable to delete resource history from " + dir.getAbsolutePath()));
            }
        }
    }
}

