/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.graph.command.FailToken;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.email.IEmailService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class EmailExceptionHandler
implements ActionHandler {
    private static final String BODY = "exception.mail.body";
    private static final String SUBJECT = "exception.mail.subject";
    private String email;
    private String subject;
    private static final String BUNDLE_NAME = EmailExceptionHandler.class.getPackage().getName() + ".mail";
    private static final Logger LOGGER = Logger.getLogger(EmailExceptionHandler.class);
    private static final long serialVersionUID = 211838311322320212L;
    private IEmailService emailService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) throws Exception {
        try {
            if (StringUtils.isNotBlank((String)this.email)) {
                ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                List<Address> emailRecipients = this.getEmailRecipients(context);
                this.getEmailService().send(emailRecipients.toArray(new Address[emailRecipients.size()]), this.getEmailSubject(bundle), this.getEmailBody(bundle, context));
                LOGGER.info((Object)(context.getToken() + ", sent email to " + this.email));
            }
        }
        catch (Throwable e) {
            LOGGER.warn((Object)(context.getToken() + ", failed to send email to " + this.email), e);
        }
        finally {
            new FailToken().execute(context);
        }
    }

    protected List<Address> getEmailRecipients(ExecutionContext context) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        String[] recipients = this.email.split(",");
        for (int i = 0; i < recipients.length; ++i) {
            Object value;
            String recipient = recipients[i].trim();
            if (recipient.startsWith("$") && (value = context.getVariable(recipient.substring(1))) instanceof String) {
                recipient = (String)value;
            }
            try {
                addresses.add((Address)new InternetAddress(recipient));
                LOGGER.debug((Object)("Sending to " + recipient));
                continue;
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        return addresses;
    }

    protected String getEmailSubject(ResourceBundle bundle) {
        if (this.subject != null && this.subject.length() > 0) {
            return this.subject;
        }
        return bundle.getString(SUBJECT);
    }

    protected String getEmailBody(ResourceBundle bundle, ExecutionContext context) {
        String name = context.getProcessDefinition().getName();
        long id = context.getProcessInstance().getId();
        String node = context.getNode().getName();
        String pattern = bundle.getString(BODY);
        return MessageFormat.format(pattern, name, id, node);
    }

    private IEmailService getEmailService() {
        if (this.emailService == null) {
            this.emailService = (IEmailService)ServiceRegistry.getDefault().lookup(IEmailService.class);
        }
        return this.emailService;
    }

    protected void setEmailService(IEmailService emailService) {
        this.emailService = emailService;
    }
}

