/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;

public class WFSElasticSearchFilterBuilder {
    public static FilterBuilder getFilterBuilder(SearchParameterBase searchParameter) {
        if (searchParameter instanceof ListParameter) {
            return WFSElasticSearchFilterBuilder.getListParameterFilter(searchParameter);
        }
        if (searchParameter instanceof RangeParameter) {
            return WFSElasticSearchFilterBuilder.getRangeParameterFilter(searchParameter);
        }
        if (searchParameter instanceof ValueParameter) {
            return WFSElasticSearchFilterBuilder.getValueParameterFilter(searchParameter);
        }
        return null;
    }

    private static Date getDateFormat(String inputDate) {
        if (inputDate == null || inputDate.equals("")) {
            return null;
        }
        Date outputDate = null;
        try {
            outputDate = new SimpleDateFormat("yyyy-MM-dd").parse(inputDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return outputDate;
    }

    private static FilterBuilder getListParameterFilter(SearchParameterBase searchParameter) {
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        List values = ((ListParameter)searchParameter).getValues();
        ListIterator<String> iterator = values.listIterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value == null || !WFSElasticSearchFilterBuilder.isProcessStatus(value.toString())) continue;
            String statusValue = value.toString().toUpperCase();
            iterator.remove();
            iterator.add(statusValue);
        }
        if (((ListParameter)searchParameter).getOperator() == SearchOperator.EQUAL) {
            return FilterBuilders.termsFilter((String)esPropertyName, (Iterable)values);
        }
        if (((ListParameter)searchParameter).getOperator() == SearchOperator.IN) {
            if (values == null || values.size() == 0) {
                return FilterBuilders.existsFilter((String)esPropertyName);
            }
            if (values.contains(ProcessStatus.ACTIVE.toString())) {
                values.add(ProcessStatus.CREATED.toString());
                values.add(ProcessStatus.BUSY.toString());
                values.add(ProcessStatus.RUNNING.toString());
            }
            return FilterBuilders.inFilter((String)esPropertyName, (Object[])values.toArray());
        }
        return null;
    }

    private static FilterBuilder getRangeParameterFilter(SearchParameterBase searchParameter) {
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        RangeFilterBuilder rangeFilterBuilder = FilterBuilders.rangeFilter((String)esPropertyName).includeLower(true).includeUpper(true);
        String from = ((RangeParameter)searchParameter).getFrom();
        String to = ((RangeParameter)searchParameter).getTo();
        Date fromDate = WFSElasticSearchFilterBuilder.getDateFormat(from);
        Date toDate = WFSElasticSearchFilterBuilder.getDateFormat(to);
        Calendar calendar = Calendar.getInstance();
        if (fromDate != null && toDate != null) {
            rangeFilterBuilder.from((Object)fromDate);
            calendar.setTime(toDate);
            calendar.add(5, 1);
            rangeFilterBuilder.lt((Object)calendar.getTime());
        } else if (fromDate != null) {
            rangeFilterBuilder.gte((Object)fromDate);
        } else if (toDate != null) {
            calendar.setTime(toDate);
            calendar.add(5, 1);
            rangeFilterBuilder.lt((Object)calendar.getTime());
        }
        return rangeFilterBuilder;
    }

    private static FilterBuilder getValueParameterFilter(SearchParameterBase searchParameter) {
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        Object value = ((ValueParameter)searchParameter).getValue();
        if (value != null && WFSElasticSearchFilterBuilder.isProcessStatus(value.toString())) {
            value = value.toString().toUpperCase();
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.EQUAL) {
            if (value == null) {
                return FilterBuilders.missingFilter((String)esPropertyName);
            }
            if (ProcessStatus.ACTIVE.toString().equals(value)) {
                return FilterBuilders.inFilter((String)esPropertyName, (String[])new String[]{ProcessStatus.CREATED.toString(), ProcessStatus.RUNNING.toString(), ProcessStatus.BUSY.toString()});
            }
            return FilterBuilders.termsFilter((String)esPropertyName, (Object[])new Object[]{value});
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.IN) {
            return FilterBuilders.inFilter((String)esPropertyName, (Object[])new Object[]{value});
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.LIKE) {
            return FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.matchPhraseQuery((String)esPropertyName, (Object)value));
        }
        return null;
    }

    private static boolean isProcessStatus(String value) {
        for (ProcessStatus status : ProcessStatus.values()) {
            if (!status.name().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

