/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.ProcessStatus;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ProcessStatusLogWriter {
    private static final String LOG_FORMAT = "application-metrics.workflow.process_status.%s.count %s %d";
    private static final Logger LOGGER = Logger.getLogger(ProcessStatusLogWriter.class);
    private static ProcessStatusLogWriter instance = ProcessStatusLogWriter.getInstance();

    public static ProcessStatusLogWriter getInstance() {
        if (instance == null) {
            instance = new ProcessStatusLogWriter();
        }
        return instance;
    }

    protected ProcessStatusLogWriter() {
    }

    public void writeLog(ProcessStatus status, AtomicInteger count) {
        try {
            long timestamp = this.getTimestamp();
            LOGGER.info((Object)String.format(LOG_FORMAT, status.toString().toLowerCase(), count, timestamp));
        }
        catch (Throwable t) {
            LOGGER.info((Object)"Error occurred while writing process status logs", t);
        }
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }
}

