/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public class AllocationKeyService
implements IAllocationKeyService {
    private static final Logger LOGGER = Logger.getLogger(AllocationKeyService.class);

    @Override
    public String generateAllocationKey(Resource resource) {
        String allocationKey = null;
        String connectionString = resource.getConnectionString();
        ResourceConnectionType connectionType = resource.getResourceType().getConnectionType();
        switch (connectionType) {
            case URL: {
                try {
                    URL url = new URI(connectionString).toURL();
                    allocationKey = url.getHost();
                    int port = url.getPort();
                    if (port == -1) break;
                    allocationKey = allocationKey + ":" + port;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("The connection string for resource[" + resource.getId() + "] is not a valid URL: " + connectionString, e);
                }
            }
            default: {
                allocationKey = connectionString;
            }
        }
        return allocationKey;
    }

    @Override
    public boolean isMatch(Resource resource, String key) {
        boolean result = false;
        if (key == null || resource == null) {
            return false;
        }
        String connectionString = resource.getConnectionString();
        ResourceConnectionType connectionType = resource.getResourceType().getConnectionType();
        switch (connectionType) {
            case URL: {
                try {
                    URL url = new URI(connectionString).toURL();
                    String host = url.getHost();
                    int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
                    String hostWithPort = host + ":" + port;
                    if (port == url.getDefaultPort()) {
                        result = key.equalsIgnoreCase(host) || key.equalsIgnoreCase(hostWithPort);
                        break;
                    }
                    result = key.equalsIgnoreCase(hostWithPort);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Failed to get the host and port from url: " + connectionString), (Throwable)e);
                }
                break;
            }
            case IP_PORT: 
            case EMAIL: {
                result = key.equalsIgnoreCase(connectionString);
                break;
            }
            default: {
                result = key.equals(connectionString);
            }
        }
        return result;
    }
}

