/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.event;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.Date;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class WorkflowProcessStatusLogEvent
extends WorkflowEvent {
    private static final long serialVersionUID = 5322475175643566347L;
    private boolean queued;
    private Token token;
    private Node node;
    private ResourceGroup resourceGroup;
    private Resource resource;
    private Date startTime;
    private Date endTime;
    private ProcessStatus operationalStatus;
    private ProcessStatus adminStatus;

    public WorkflowProcessStatusLogEvent(boolean queued, Token token, ResourceGroup group, Resource resource, Date startTime, Date endTime) {
        this.queued = queued;
        this.token = token;
        this.node = ((CustomToken)CustomToken.class.cast(token)).getCurrentNode();
        this.resourceGroup = group;
        this.resource = resource;
        this.startTime = startTime;
        this.endTime = endTime;
        this.operationalStatus = ((CustomToken)CustomToken.class.cast(token)).getStatus();
        this.adminStatus = ((CustomToken)CustomToken.class.cast(token)).getRequestedStatus();
    }

    public ProcessStatus getAdminStatus() {
        return this.adminStatus;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Node getNode() {
        return this.node;
    }

    public ProcessStatus getOperationalStatus() {
        return this.operationalStatus;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Token getToken() {
        return this.token;
    }

    public boolean isTrace() {
        WorkflowProcess process = ((CustomToken)CustomToken.class.cast(this.token)).getProcessInstance();
        return process.getLogLevel().compareTo((Enum)LogLevel.OFF) > 0;
    }
}

