/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.dao;

import com.tandbergtv.workflow.dao.DataAccessInterface;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;

public abstract class HibernateDAO<DO, DOK extends Serializable>
implements DataAccessInterface<DO, DOK> {
    private Class<DO> persistentClass;
    private Session session;

    public HibernateDAO(Class<DO> persistentClass, Session session) {
        this.persistentClass = persistentClass;
        this.session = session;
    }

    protected Session getSession() {
        return this.session;
    }

    public Class<DO> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public DO create(DO entity) {
        Logger log = Logger.getLogger(this.getClass());
        log.debug((Object)"Creating new entity in the DB...");
        DO createdEntity = this.persist(entity);
        log.debug((Object)"Successfully created new entity in DB.");
        return createdEntity;
    }

    @Override
    public DO update(DO entity) {
        Logger log = Logger.getLogger(this.getClass());
        log.debug((Object)"Updating existing entity in the DB...");
        DO updatedEntity = this.persist(entity);
        log.debug((Object)"Successfully updated entity in DB.");
        return updatedEntity;
    }

    protected DO persist(DO entity) {
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public void delete(DOK entityKey) {
        Logger log = Logger.getLogger(this.getClass());
        log.debug((Object)("Deleting existing entity in the DB with key: " + entityKey.toString()));
        DO entity = this.findByKey(entityKey);
        this.getSession().delete(entity);
        log.debug((Object)("Successfully deleted existing entity in the DB with key: " + entityKey.toString()));
    }

    @Override
    public DO findByKey(DOK key) {
        Logger log = Logger.getLogger(this.getClass());
        log.debug((Object)("Finding Entity in the DB with key: " + key.toString()));
        Object entity = this.getSession().load(this.getPersistentClass(), key);
        log.debug((Object)("Found Entity in the DB with key: " + key.toString()));
        return (DO)entity;
    }

    @Override
    public List<DO> findAll() {
        Logger log = Logger.getLogger(this.getClass());
        log.debug((Object)"Finding all entities in the DB...");
        List<DO> entityList = this.findByCriteria(new Criterion[0]);
        log.debug((Object)("Successfully found all entities(" + entityList.size() + ") in the DB."));
        return entityList;
    }

    protected DO findUniqueByCriteria(Criterion ... criterion) {
        return (DO)this.createCriteria(criterion).uniqueResult();
    }

    protected DO findUniqueByCriteria(Criteria criteria) {
        return (DO)criteria.uniqueResult();
    }

    protected List<DO> findByCriteria(Criterion ... criterion) {
        return this.createCriteria(criterion).list();
    }

    protected List<DO> findByCriteria(Criteria criteria) {
        return criteria.list();
    }

    protected Criteria createCriteria(Criterion ... criterion) {
        Criteria criteria = this.getSession().createCriteria(this.getPersistentClass());
        for (Criterion c : criterion) {
            criteria.add(c);
        }
        return criteria;
    }
}

