/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.transport.TransportClient;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExceptionTest
extends NormalTestBase {
    private static final int DEFAULT_WAIT_TIME = 300000;
    private TransportClient client;
    private LogReader logReader;
    private static final int WAIT_FOR_ELASTICSEARCH = 20;

    @BeforeClass
    protected void setup() throws IOException {
        this.client = ESTransportClient.getTransportClient();
        this.logReader = new LogReader(this.client);
    }

    @Test
    public void testCatchException() throws Exception {
        WorkflowProcess wp = this.run("exception-catch-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
    }

    @Test
    public void testIgnoreException() throws Exception {
        WorkflowProcess wp = this.run("exception-ignore-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
    }

    @Test
    public void testRetryException() throws Exception {
        WorkflowProcess wp = this.run("exception-retry-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
        TimeUnit.SECONDS.sleep(20L);
        int totalmessageLogs = this.logReader.getLogs(wp.getId(), MessageLog.class).size();
        ExceptionTest.assertEquals((int)totalmessageLogs, (int)6);
    }

    @Test
    public void testGlobalCatchException() throws Exception {
        WorkflowProcess wp = this.run("global-exception-catch-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
    }

    @Test
    public void testGlobalIgnoreException() throws Exception {
        WorkflowProcess wp = this.run("global-exception-ignore-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
    }

    @Test
    public void testGlobalFailException() throws Exception {
        WorkflowProcess wp = this.run("global-exception-nack-message-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(wp.getId(), 300000L, ProcessStatus.ERROR));
    }

    @Test
    public void testGlobalRetryException() throws Exception {
        WorkflowProcess wp = this.run("global-exception-retry-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
        TimeUnit.SECONDS.sleep(20L);
        int totalmessageLogs = this.logReader.getLogs(wp.getId(), MessageLog.class).size();
        ExceptionTest.assertEquals((int)totalmessageLogs, (int)6);
    }

    @Test
    public void testGlobalFailNodeIgnoreException() throws Exception {
        WorkflowProcess wp = this.run("global-fail-node-ignore-exception-test");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
    }

    @Test
    public void testSubProcessGlobalFailException() throws Exception {
        WorkflowProcess wp = this.run("subprocess-global-fail-exception-parent-template");
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(wp.getId(), 300000L, ProcessStatus.ERROR));
        WorkflowProcess child = ProcessUtils.get(wp.getId()).getRootToken().getSubProcessInstance();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(child.getId(), 300000L, ProcessStatus.ERROR));
    }

    @Test
    public void testSubProcessGlobalIgnoreException() throws Exception {
        WorkflowProcess wp = this.run("subprocess-global-ignore-exception-parent-template");
        long id = wp.getId();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        long childId = ((WorkflowProcess)ProcessUtils.get(id).getSubProcessInstances().iterator().next()).getId();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(childId, 300000L));
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 300000L));
    }

    @Test
    public void testParentGlobalIgnoreException() throws Exception {
        WorkflowProcess wp = this.run("parent-global-ignore-subprocess-unhandled-exception");
        long id = wp.getId();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        WorkflowProcess child = ProcessUtils.get(id).getRootToken().getSubProcessInstance();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(child.getId(), 300000L, ProcessStatus.ERROR));
    }

    @Test
    public void testParentGlobalFailException() throws Exception {
        WorkflowProcess wp = this.run("parent-global-fail-subprocess-unhandled-exception");
        long id = wp.getId();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        WorkflowProcess child = ProcessUtils.get(id).getRootToken().getSubProcessInstance();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(wp.getId(), 300000L, ProcessStatus.ERROR));
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(child.getId(), 300000L, ProcessStatus.ERROR));
    }

    @Test
    public void testParentGlobalCatchException() throws Exception {
        WorkflowProcess wp = this.run("parent-global-catch-subprocess-unhandled-exception");
        long id = wp.getId();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 5000L, ProcessStatus.BUSY));
        TimeUnit.SECONDS.sleep(5L);
        WorkflowProcess child = ProcessUtils.get(id).getRootToken().getSubProcessInstance();
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 300000L));
        ExceptionTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(child.getId(), 300000L, ProcessStatus.ERROR));
    }
}

