/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.rest.services.internal.TasksResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class UserTaskResourceTest
extends RESTServiceMockTestBase {
    private static final String RESOURCE_TYPE_SYSTEM_ID = "04";
    private static final String RESOURCE_NAME_PREFIX = "UTR";
    private static long resourceId;
    private static final String RESOURCE_NAME = "admin";
    private static final String RESOURCE_GROUP = "Human";
    private static final String TEMPLATE = "UserTaskTemplate";
    private static final String TASK_NAME = "manual-task1";
    private static final String API_PATH = "/tasks/";
    private static final String PROVIDER_ID_KEY = "providerId";
    private static final String TITLE_ID_KEY = "titleId";
    private static final String TITLE_ID = "3";
    private static final String PROVIDER_ID = "TTV.COM";
    private static final Object TASKS_FIELD_NAME;

    public UserTaskResourceTest() {
        super(TasksResource.class);
    }

    @BeforeMethod
    public void setup() throws ResourceManagementException, ValidationException {
        resourceId = TestUtil.getService(ResourceManagement.class).getResourceByName(RESOURCE_NAME).getId();
        ResourceUtils.setResourcesOffline(RESOURCE_TYPE_SYSTEM_ID);
    }

    @AfterClass
    public void cleanup() throws ResourceManagementException {
        ResourceUtils.setResourcesOnline(RESOURCE_TYPE_SYSTEM_ID);
    }

    @Test(enabled=false)
    public void validateResponse() throws ResourceManagementException, InterruptedException, DriverException, JsonParseException, JsonMappingException, IOException {
        ResourceUtils.setResourceOnline(resourceId);
        UserTaskResourceTest.assertEquals((Object)ResourceUtils.getResource(resourceId).getOperationalState(), (Object)ResourceState.ONLINE);
        List<WorkflowProcess> processes = this.createProcesses(3);
        for (WorkflowProcess process : processes) {
            ProcessUtils.assertStatus(process.getId(), ProcessStatus.BUSY, 2000L);
        }
        String uri = "/tasks/admin";
        Map<String, Object> responseMap = this.getResponseMap(uri);
        this.validateResponse(responseMap);
    }

    @Test(enabled=false)
    public void userOffline() throws ResourceManagementException, InterruptedException, DriverException, JsonParseException, JsonMappingException, IOException, ValidationException {
        Resource resource = ResourceUtils.createResource(ResourceUtils.getResourceBuilderFromSystemId(RESOURCE_TYPE_SYSTEM_ID, RESOURCE_NAME_PREFIX));
        resource.setUserName(resource.getName());
        ResourceUtils.setResourceOffline(resource.getId());
        UserTaskResourceTest.assertEquals((Object)ResourceUtils.getResource(resource.getId()).getOperationalState(), (Object)ResourceState.OFFLINE);
        List<WorkflowProcess> processes = this.createProcesses(1);
        for (WorkflowProcess process : processes) {
            ProcessUtils.assertStatus(process.getId(), ProcessStatus.QUEUED, 2000L);
        }
        String uri = API_PATH + resource.getUserName();
        Map<String, Object> responseMap = this.getResponseMap(uri);
        UserTaskResourceTest.assertEquals((String)responseMap.get("total").toString(), (String)"0");
    }

    public void userDoesNotExist() throws URISyntaxException {
        String uri = "/tasks/dummy";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        UserTaskResourceTest.assertEquals((int)response.getStatus(), (int)404);
    }

    public void badRequest() throws ValidationException, DriverException, URISyntaxException, JsonParseException, JsonMappingException, IOException, ResourceManagementException, InterruptedException {
        String uri = "/tasks/admin";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        UserTaskResourceTest.assertEquals((int)response.getStatus(), (int)400);
    }

    private List<WorkflowProcess> createProcesses(int i) throws InterruptedException, DriverException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PROVIDER_ID_KEY, PROVIDER_ID);
        params.put(TITLE_ID_KEY, TITLE_ID);
        return this.runMultiple(TEMPLATE, params, i);
    }

    private void validateResponse(Map<String, Object> map) {
        UserTaskResourceTest.assertTrue((Integer.parseInt(map.get("total").toString()) >= 3 ? 1 : 0) != 0);
        UserTaskResourceTest.assertEquals((String)map.get("count").toString(), (String)"10");
        UserTaskResourceTest.assertEquals((String)map.get("start").toString(), (String)"0");
        List tasks = (List)map.get(TASKS_FIELD_NAME);
        for (Map task : tasks) {
            if (!task.get("template").toString().contains(TEMPLATE)) continue;
            UserTaskResourceTest.assertTrue((task.get("id") != null ? 1 : 0) != 0);
            UserTaskResourceTest.assertEquals((String)task.get("name").toString(), (String)TASK_NAME);
            UserTaskResourceTest.assertTrue((boolean)task.get("template").toString().contains(TEMPLATE));
            UserTaskResourceTest.assertEquals((String)task.get("group").toString(), (String)RESOURCE_GROUP);
            UserTaskResourceTest.assertTrue((task.get("taskId") != null ? 1 : 0) != 0);
            UserTaskResourceTest.assertEquals((String)task.get(PROVIDER_ID_KEY).toString(), (String)PROVIDER_ID);
        }
    }

    static {
        TASKS_FIELD_NAME = "tasks";
    }
}

