/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import java.lang.reflect.Constructor;

public class HandlerFactory {
    private HandlerFactory() {
    }

    public static HandlerFactory newInstance() {
        return new HandlerFactory();
    }

    public IHandler createHandler(IHandlerConfiguration conf) throws HandlerException {
        IHandler handler = null;
        String className = conf.getClassName();
        try {
            Class<?> clazz = conf.getClassLoader().loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(IHandlerConfiguration.class);
            handler = (IHandler)constructor.newInstance(conf);
        }
        catch (Exception e) {
            throw new HandlerException("Handler class " + className + " could not be instantiated", e);
        }
        return handler;
    }
}

