/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.tandbergtv.workflow.adaptor.conf.DispatcherParameter;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPMethod;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class HTTPDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(HTTPDispatcher.class);

    public HTTPDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public IMessage send(IMessage msg) throws DispatcherException {
        URL url = null;
        logger.debug((Object)("Sending message to: " + this.getDestination()));
        try {
            url = new URL(((HTTPDevice)this.getDestination()).getUrl());
            URLConnection conn = url.openConnection();
            String timeout = this.getConfiguration().getParameterValue(DispatcherParameter.CONNECTION_TIMEOUT);
            if (timeout != null) {
                try {
                    logger.debug((Object)("Timeout read from the config : " + timeout));
                    int connectTimeout = Integer.parseInt(timeout);
                    conn.setConnectTimeout(connectTimeout * 1000);
                }
                catch (Exception ex) {
                    logger.error((Object)("Timeout specified " + timeout + " is not an integer." + " It should be an integer value in seconds."));
                }
            }
            this.addHeaders(conn);
            HTTPMessage message = (HTTPMessage)msg;
            HTTPPayload payload = (HTTPPayload)message.getPayload();
            HTTPMethod method = message.getMethod();
            if (!HTTPMethod.GET.equals((Object)method)) {
                this.sendMessage(conn, payload.getContent());
            }
            String response = this.getResponse(conn);
            HTTPMessage responseMsg = new HTTPMessage(new HTTPPayload(response));
            logger.debug((Object)("Received message: " + responseMsg));
            return responseMsg;
        }
        catch (MalformedURLException ex) {
            throw new DispatcherException("Invalid url: " + url, ex);
        }
        catch (IOException ex) {
            throw new DispatcherException("Could not open a connection to destination URL.", ex);
        }
    }

    protected void addHeaders(URLConnection conn) {
        String soapAction = this.getConfiguration().getParameterValue(DispatcherParameter.SOAP_ACTION);
        if (soapAction == null) {
            conn.setRequestProperty("SOAPAction", "");
        } else {
            conn.setRequestProperty("SOAPAction", soapAction);
        }
        String contentType = this.getConfiguration().getParameterValue(DispatcherParameter.CONTENT_TYPE);
        if (contentType != null) {
            conn.setRequestProperty("Content-Type", contentType);
        }
    }

    protected void sendMessage(URLConnection conn, String dataToSend) throws DispatcherException {
        try {
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            writer.write(dataToSend);
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            throw new DispatcherException("Could not write data to destination URL.", ex);
        }
    }

    protected String getResponse(URLConnection conn) throws DispatcherException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
        }
        catch (IOException ex) {
            throw new DispatcherException("Could not read response from destination URL.", ex);
        }
        return stringBuilder.toString();
    }
}

