/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.util.URLConfigReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ApplicationProperties
extends Properties {
    private static final long serialVersionUID = -2440412148987996833L;
    private static final Logger logger = Logger.getLogger(ApplicationProperties.class);
    private static final String PROPERTIES_FILE_PATH = "/application.properties";
    private static final String URL_CONFIG_FILENAME = "url-config.xml";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private static final String LIB_DIR = "lib";
    private static final String CONF_DIR = "conf";
    private static ApplicationProperties m_Instance;

    private ApplicationProperties() throws InvalidPropertiesFormatException, IOException {
        this.loadProperties();
        this.createConfigPathFolder();
    }

    public static synchronized ApplicationProperties getInstance() throws InvalidPropertiesFormatException, IOException {
        if (m_Instance == null) {
            m_Instance = new ApplicationProperties();
        }
        return m_Instance;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        InputStream inStream = this.getClass().getResourceAsStream(PROPERTIES_FILE_PATH);
        this.loadFromXML(inStream);
        IConfigurationService configReaderService = (IConfigurationService)ServiceRegistry.getDefault().lookup("Configuration Admin");
        if (configReaderService == null) {
            return;
        }
        String dir = configReaderService.getInstallDirectory();
        String workflowroot = dir + File.separator + WORKFLOW_FOLDER_NAME;
        this.setProperty("install.dir", workflowroot);
        this.setProperty("clientClassesDirectory", workflowroot + File.separator + LIB_DIR);
        this.setProperty("WorkflowApp.ConfigPath", dir + File.separator + CONF_DIR + File.separator + WORKFLOW_FOLDER_NAME);
        File urlConfigFile = configReaderService.getFile(WORKFLOW_FOLDER_NAME, URL_CONFIG_FILENAME);
        Map<String, String> urlProperties = URLConfigReader.read(urlConfigFile);
        for (String urlKey : urlProperties.keySet()) {
            this.setProperty(urlKey, urlProperties.get(urlKey));
        }
    }

    private void createConfigPathFolder() {
        String configPath = this.getProperty("WorkflowApp.ConfigPath");
        if (configPath != null && configPath.trim().length() > 0) {
            File file = new File(configPath);
            try {
                if (!file.exists()) {
                    file.mkdirs();
                }
                logger.debug((Object)("The Workflow System configuration folder: " + file.getAbsolutePath() + " exists."));
            }
            catch (Exception ex) {
                String msg = "Failed to create the Workflow System configuration folder: " + file.getAbsolutePath();
                logger.error((Object)msg, (Throwable)ex);
            }
        } else {
            String msg = "The Workflow System configuration folder is not configured in the Application Properties, please enter a value for key: WorkflowApp.ConfigPath";
            logger.warn((Object)msg);
        }
    }
}

