/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager;

import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.pluginmanager.util.ExtensionParser;
import com.tandbergtv.workflow.pluginmanager.util.ResourceGroupExtensionParser;
import com.tandbergtv.workflow.pluginmanager.util.ResourceGroupPluginValidator;
import com.tandbergtv.workflow.pluginmanager.util.ResourceTypeDescriptorValidator;
import com.tandbergtv.workflow.pluginmanager.util.ResourceTypeExtensionValidator;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class WatchPointPluginManager
implements PluginManagement {
    private static final Logger logger = Logger.getLogger(WatchPointPluginManager.class);
    private static final String WATCHPOINT_PLUGIN_ID = "com.tandbergtv.workflow";
    private static final String RESOURCE_TYPE_EXTENSION_POINT_ID = "resourcetype";
    private static final String RESOURCE_GROUP_EXTENSION_POINT_ID = "resourcegroup";
    private static final String RESOURCE_TYPES = "resourceTypes";
    private boolean isInitialized = false;
    private PluginManager pluginManager;
    private Map<String, ResourceTypeDescriptor> resTypeDescriptors = new Hashtable<String, ResourceTypeDescriptor>();
    private Map<String, ResourceTypeDescriptor> nonLicResTypeDescriptors = new Hashtable<String, ResourceTypeDescriptor>();
    List<ResourceTypeDescriptor> sortedResTypeDescriptors = new ArrayList<ResourceTypeDescriptor>();
    private Map<String, ResourceGroupDescriptor> resGroupDescriptors = new Hashtable<String, ResourceGroupDescriptor>();
    private List<FailureDescriptor> failedDescriptors = new ArrayList<FailureDescriptor>();
    private List<FailureDescriptor> failedRGDescriptors = new ArrayList<FailureDescriptor>();
    private Map<String, FailureDescriptor> missingRGDescriptors = new HashMap<String, FailureDescriptor>();
    private Map<String, FailureDescriptor> unacceptedRGDescriptors = new HashMap<String, FailureDescriptor>();

    public static PluginManagement getInstance() {
        return (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
    }

    public WatchPointPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    private void initializeManager() throws InvalidLicenseException {
        if (this.isInitialized) {
            return;
        }
        logger.debug((Object)"Initializing the Plugin Manager...");
        this.loadResourceTypeDescriptors();
        this.loadResourceGroupDescriptors();
        this.checkLicense();
        this.isInitialized = true;
        logger.debug((Object)"Finished initializing the Plugin Manager...");
    }

    private void loadResourceTypeDescriptors() {
        this.resTypeDescriptors.clear();
        this.failedDescriptors.clear();
        this.nonLicResTypeDescriptors.clear();
        this.sortedResTypeDescriptors.clear();
        logger.debug((Object)"Loading the Resource Type Descriptors...");
        PluginRegistry registry = this.pluginManager.getRegistry();
        PathResolver pathResolver = this.pluginManager.getPathResolver();
        IntegrityCheckReport report = registry.checkIntegrity(pathResolver, true);
        ExtensionPoint rtPoint = registry.getExtensionPoint(WATCHPOINT_PLUGIN_ID, RESOURCE_TYPE_EXTENSION_POINT_ID);
        ArrayList<String> failedPlugins = new ArrayList<String>();
        for (Extension extension : rtPoint.getAvailableExtensions()) {
            PluginDescriptor pluginDesc;
            PluginClassLoader loader;
            ResourceTypeDescriptor descriptor;
            FailureDescriptor failedDescriptor = this.validateResourceTypeExtension(extension, report);
            if (failedDescriptor == null && (failedDescriptor = this.validateResourceTypeDescriptor(descriptor = ExtensionParser.parseResourceTypeExtension(extension, (ClassLoader)(loader = this.pluginManager.getPluginClassLoader(pluginDesc = extension.getDeclaringPluginDescriptor()))))) == null) {
                this.resTypeDescriptors.put(descriptor.getSystemId(), descriptor);
                this.sortedResTypeDescriptors.add(descriptor);
            }
            if (failedDescriptor == null) continue;
            this.failedDescriptors.add(failedDescriptor);
            failedPlugins.add(failedDescriptor.getPluginId());
        }
        if (failedPlugins.size() > 0) {
            registry.unregister(failedPlugins.toArray(new String[0]));
            logger.debug((Object)("Found : " + failedPlugins.size() + " invalid plugins."));
        }
        logger.debug((Object)("Finished loading: " + this.resTypeDescriptors.size() + " plugins at startup."));
    }

    private void loadResourceGroupDescriptors() {
        logger.debug((Object)"Loading Resource Group Descriptors...");
        PluginRegistry registry = this.pluginManager.getRegistry();
        PathResolver pathResolver = this.pluginManager.getPathResolver();
        IntegrityCheckReport report = registry.checkIntegrity(pathResolver, true);
        ExtensionPoint rtPoint = registry.getExtensionPoint(WATCHPOINT_PLUGIN_ID, RESOURCE_GROUP_EXTENSION_POINT_ID);
        ArrayList<String> failedPluginIDs = new ArrayList<String>();
        for (Extension extension : rtPoint.getAvailableExtensions()) {
            logger.debug((Object)("Extension ID: " + extension.getId().toString()));
            FailureDescriptor failedDescriptor = ResourceGroupPluginValidator.validateExtension(extension, report);
            if (failedDescriptor == null) {
                PluginDescriptor pluginDesc = extension.getDeclaringPluginDescriptor();
                PluginClassLoader loader = this.pluginManager.getPluginClassLoader(pluginDesc);
                ResourceGroupDescriptor rgDescriptor = ResourceGroupExtensionParser.parse(extension, (ClassLoader)loader);
                logger.debug((Object)("Parsed Res Grp Descriptor: " + rgDescriptor.toString()));
                failedDescriptor = ResourceGroupPluginValidator.validateDescriptor(rgDescriptor, this.resGroupDescriptors.containsKey(rgDescriptor.getName()));
                if (failedDescriptor == null) {
                    this.resGroupDescriptors.put(rgDescriptor.getName(), rgDescriptor);
                } else {
                    logger.debug((Object)"Resource group description validation failed");
                }
            } else {
                logger.debug((Object)"Resource group extension validation failed");
            }
            if (failedDescriptor == null) continue;
            logger.debug((Object)("Failure Descriptor: " + failedDescriptor.toString()));
            this.failedRGDescriptors.add(failedDescriptor);
            failedPluginIDs.add(failedDescriptor.getPluginId());
        }
        if (failedPluginIDs.size() > 0) {
            registry.unregister(failedPluginIDs.toArray(new String[0]));
            logger.debug((Object)("Found " + failedPluginIDs.size() + " invalid plugins."));
        }
        logger.debug((Object)("Finished loading " + this.resGroupDescriptors.size() + " Resource Group Descriptors..."));
    }

    private void checkLicense() throws InvalidLicenseException {
        LicenseManager licManager = LicenseManager.getInstance();
        String resourceTypesEntry = licManager.getObject(RESOURCE_TYPES);
        if (resourceTypesEntry == null || resourceTypesEntry.trim().length() == 0) {
            return;
        }
        int numOfLicResTypes = Integer.parseInt(resourceTypesEntry.trim());
        if (numOfLicResTypes < 0) {
            throw new InvalidLicenseException("Invalid License for resource types - non-negative value must be specified");
        }
        if (numOfLicResTypes >= this.resTypeDescriptors.size()) {
            return;
        }
        Collections.sort(this.sortedResTypeDescriptors);
        ArrayList<String> failedPlugins = new ArrayList<String>();
        for (int i = this.sortedResTypeDescriptors.size() - 1; i > numOfLicResTypes - 1; --i) {
            ResourceTypeDescriptor tempResTypeDesc = this.sortedResTypeDescriptors.get(i);
            String systemId = tempResTypeDesc.getSystemId();
            ResourceTypeDescriptor descriptor = this.resTypeDescriptors.remove(systemId);
            logger.debug((Object)("Removed " + descriptor.getSystemId() + " from resTypeDescriptors, new size is " + this.resTypeDescriptors.size()));
            String msg = "The Plugin for Resource Type: " + descriptor.getName() + "[" + descriptor.getSystemId() + "] is invalid due to a limited number of licenses: " + numOfLicResTypes;
            this.addNonLicensedResourceTypeDescriptor(descriptor, msg);
            failedPlugins.add(descriptor.getPluginId());
        }
        PluginRegistry registry = this.pluginManager.getRegistry();
        if (failedPlugins.size() > 0) {
            registry.unregister(failedPlugins.toArray(new String[0]));
            logger.debug((Object)("Found : " + failedPlugins.size() + " invalid plugins due to a limited license."));
        }
    }

    private FailureDescriptor validateResourceTypeExtension(Extension extension, IntegrityCheckReport report) {
        List<String> messages = ResourceTypeExtensionValidator.validate(extension, report);
        return this.prepareFailureDescriptor(extension, messages);
    }

    private FailureDescriptor prepareFailureDescriptor(Extension extension, List<String> messages) {
        FailureDescriptor result = null;
        if (messages.size() > 0) {
            result = new FailureDescriptor();
            result.setPluginId(extension.getDeclaringPluginDescriptor().getId());
            result.setExtensionId(extension.getId());
            Extension.Parameter param = extension.getParameter("systemId");
            if (param != null) {
                result.setId(param.valueAsString());
            }
            if ((param = extension.getParameter("name")) != null) {
                result.setName(param.valueAsString());
            }
            result.setSummaryMessage("The Plugin Extension has failed basic validation.");
            result.setErrorMessages(messages);
        }
        return result;
    }

    private FailureDescriptor validateResourceTypeDescriptor(ResourceTypeDescriptor descriptor) {
        FailureDescriptor result = null;
        List<String> messages = ResourceTypeDescriptorValidator.validate(descriptor);
        String systemId = descriptor.getSystemId();
        if (this.resTypeDescriptors.containsKey(systemId)) {
            messages.add("The System Id specified is already used by another Resource Type.");
        }
        if (messages.size() > 0) {
            result = new FailureDescriptor();
            result.setPluginId(descriptor.getPluginId());
            result.setExtensionId(descriptor.getExtensionId());
            result.setId(descriptor.getSystemId());
            result.setCreateDate(descriptor.getCreateDate());
            result.setName(descriptor.getName());
            result.setSummaryMessage("Plugin Extension was successfully loaded, but failed validation.");
            result.setErrorMessages(messages);
        }
        return result;
    }

    @Override
    public synchronized ResourceTypeDescriptor getResourceTypeDescriptor(String systemId) {
        ResourceTypeDescriptor result = null;
        ResourceTypeDescriptor descriptor = this.resTypeDescriptors.get(systemId);
        if (descriptor != null) {
            result = (ResourceTypeDescriptor)descriptor.clone();
        }
        return result;
    }

    @Override
    public synchronized List<ResourceTypeDescriptor> getResourceTypeDescriptors() {
        ArrayList<ResourceTypeDescriptor> result = new ArrayList<ResourceTypeDescriptor>();
        for (ResourceTypeDescriptor descriptor : this.resTypeDescriptors.values()) {
            ResourceTypeDescriptor clone = (ResourceTypeDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    @Override
    public synchronized List<ResourceGroupDescriptor> getResourceGroupDescriptors() {
        ArrayList<ResourceGroupDescriptor> result = new ArrayList<ResourceGroupDescriptor>();
        for (ResourceGroupDescriptor descriptor : this.resGroupDescriptors.values()) {
            result.add((ResourceGroupDescriptor)descriptor.clone());
        }
        return result;
    }

    @Override
    public synchronized ResourceGroupDescriptor getResourceGroupDescriptor(String name) {
        if (this.resGroupDescriptors != null && this.resGroupDescriptors.containsKey(name)) {
            return (ResourceGroupDescriptor)this.resGroupDescriptors.get(name).clone();
        }
        return null;
    }

    @Override
    public synchronized List<FailureDescriptor> getFailureDescriptors() {
        ArrayList<FailureDescriptor> result = new ArrayList<FailureDescriptor>();
        for (FailureDescriptor descriptor : this.failedDescriptors) {
            FailureDescriptor clone = (FailureDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    @Override
    public synchronized List<ResourceTypeDescriptor> getNonLicensedDescriptors() {
        ArrayList<ResourceTypeDescriptor> result = new ArrayList<ResourceTypeDescriptor>();
        for (ResourceTypeDescriptor descriptor : this.nonLicResTypeDescriptors.values()) {
            result.add((ResourceTypeDescriptor)descriptor.clone());
        }
        return result;
    }

    @Override
    public synchronized ResourceTypeDescriptor getNonLicensedDescriptor(String systemId) {
        ResourceTypeDescriptor result = null;
        ResourceTypeDescriptor descriptor = this.nonLicResTypeDescriptors.get(systemId);
        if (descriptor != null) {
            result = (ResourceTypeDescriptor)descriptor.clone();
        }
        return result;
    }

    @Override
    public synchronized List<FailureDescriptor> getFailedResourceGroupDescriptors() {
        return this.clone(this.failedRGDescriptors);
    }

    @Override
    public synchronized List<FailureDescriptor> getMissingResourceGroups() {
        return this.clone(this.missingRGDescriptors.values());
    }

    @Override
    public synchronized List<FailureDescriptor> getUnacceptedResourceGroupDescriptors() {
        return this.clone(this.unacceptedRGDescriptors.values());
    }

    private List<FailureDescriptor> clone(Collection<FailureDescriptor> descriptors) {
        ArrayList<FailureDescriptor> result = new ArrayList<FailureDescriptor>();
        for (FailureDescriptor descriptor : descriptors) {
            FailureDescriptor clone = (FailureDescriptor)descriptor.clone();
            result.add(clone);
        }
        return result;
    }

    private void addNonLicensedResourceTypeDescriptor(ResourceTypeDescriptor descriptor, String msg) {
        descriptor.setSummaryMessage(msg);
        this.nonLicResTypeDescriptors.put(descriptor.getSystemId(), descriptor);
    }

    @Override
    public synchronized void addMissingResourceTypeDescriptor(ResourceType resourceType) {
        String systemId = resourceType.getSystemId();
        String name = resourceType.getName();
        for (FailureDescriptor descriptor : this.failedDescriptors) {
            if (!systemId.equals(descriptor.getId())) continue;
            return;
        }
        FailureDescriptor descriptor = new FailureDescriptor();
        descriptor.setId(systemId);
        descriptor.setName(name);
        String msg = "The Plugin for Resource Type: " + name + "[" + systemId + "] is missing or is invalid.";
        descriptor.setSummaryMessage(msg);
        this.failedDescriptors.add(descriptor);
    }

    @Override
    public synchronized void notifyMissingResourceGroup(String name, String systemID) {
        logger.debug((Object)("Missing Resource Group | Name: " + name + " System ID: " + systemID));
        FailureDescriptor failureDesc = this.missingRGDescriptors.get(name);
        if (failureDesc == null) {
            failureDesc = new FailureDescriptor();
            this.missingRGDescriptors.put(name, failureDesc);
            failureDesc.setId(systemID);
            failureDesc.setName(name);
            failureDesc.addErrorMessage("Plugin is missing.");
        }
    }

    @Override
    public synchronized void notifyUnacceptedResourceGroupDescriptor(ResourceGroupDescriptor descriptor, Collection<String> messages) {
        logger.debug((Object)("Resource Group Descriptor: " + descriptor + "\nMessages: " + messages));
        FailureDescriptor failureDesc = this.unacceptedRGDescriptors.get(descriptor.getName());
        if (failureDesc == null) {
            failureDesc = new FailureDescriptor();
            failureDesc.setName(descriptor.getName());
            failureDesc.setId(descriptor.getSystemId());
            this.unacceptedRGDescriptors.put(descriptor.getName(), failureDesc);
        }
        failureDesc.addErrorMessages(messages);
    }

    @Override
    public synchronized void notifyUnacceptedResourceGroupDescriptor(ResourceGroupDescriptor descriptor, String message) {
        logger.debug((Object)("Resource Group Descriptor: " + descriptor + "\nMessage: " + message));
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(message);
        this.notifyUnacceptedResourceGroupDescriptor(descriptor, messages);
    }

    public synchronized void start() {
        try {
            this.initializeManager();
        }
        catch (InvalidLicenseException e) {
            throw new RuntimeException("Failed to load plugins", e);
        }
    }

    public synchronized void stop() {
        if (!this.isInitialized) {
            return;
        }
        this.isInitialized = false;
    }

    public String getServiceName() {
        return "Plugin Management";
    }
}

