/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ResourceGroupQueue
implements ResourceEntity,
Iterable<ResourceGroupQueueItem> {
    private static final long serialVersionUID = -5418538065738959637L;
    private static final Logger logger = Logger.getLogger(ResourceGroupQueue.class);
    private ResourceGroup parentGroup;
    private transient int max;
    private transient long totalDelay;
    private transient int added;
    private transient int removed;
    private List<ResourceGroupQueueItem> queue = new ArrayList<ResourceGroupQueueItem>();

    public ResourceGroupQueue() {
    }

    public ResourceGroupQueue(ResourceGroup parent) {
        this.parentGroup = parent;
    }

    public ResourceGroup getResourceGroup() {
        return this.parentGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.parentGroup = resourceGroup;
        if (this.queue != null) {
            for (ResourceGroupQueueItem item : this.queue) {
                if (item == null) continue;
                item.setResourceGroup(resourceGroup);
            }
        }
    }

    public int getMax() {
        return this.max;
    }

    public int getAdded() {
        return this.added;
    }

    public int getRemoved() {
        return this.removed;
    }

    public long getTotalDelay() {
        return this.totalDelay;
    }

    @Deprecated
    public List<ResourceGroupQueueItem> getQueuedItems() {
        return this.queue;
    }

    @Deprecated
    public void setQueuedItems(List<ResourceGroupQueueItem> queuedItems) {
        boolean hasNullItems;
        if (queuedItems == null) {
            queuedItems = new ArrayList<ResourceGroupQueueItem>();
        }
        if (hasNullItems = queuedItems.contains(null)) {
            logger.warn((Object)("Found null items in the queue for " + this.getGroupName() + " when loading the queue, filtering all null items."));
        }
        while (hasNullItems) {
            hasNullItems = queuedItems.remove(null);
        }
        this.queue = queuedItems;
    }

    public void add(ResourceGroupQueueItem queueItem) {
        this.add(this.queue.size(), queueItem);
    }

    public void add(int index, ResourceGroupQueueItem queueItem) {
        if (queueItem == null) {
            String msg = "Attempting to add null item to the queue for " + this.getGroupName() + ", ignoring null item.";
            logger.warn((Object)msg, (Throwable)new Exception("Cannot add null queue item to the queue."));
            return;
        }
        queueItem.setResourceGroup(this.parentGroup);
        this.queue.add(index, queueItem);
        ++this.added;
        if (this.max < this.queue.size()) {
            this.max = this.queue.size();
        }
    }

    public boolean remove(ResourceGroupQueueItem queueItem) {
        this.totalDelay += System.currentTimeMillis() - queueItem.getQueuedDate().getTime();
        ++this.removed;
        return this.queue.remove(queueItem);
    }

    public void clear() {
        this.queue.clear();
    }

    public ResourceGroupQueueItem get(int index) {
        return this.queue.get(index);
    }

    public boolean contains(ResourceGroupQueueItem queueItem) {
        return this.queue.contains(queueItem);
    }

    public int indexOf(ResourceGroupQueueItem queueItem) {
        return this.queue.indexOf(queueItem);
    }

    public ResourceGroupQueueItem findItem(long tokenId) {
        for (ResourceGroupQueueItem item : this.queue) {
            if (item.getTokenId() != tokenId) continue;
            return item;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<ResourceGroupQueueItem> iterator() {
        return this.queue.iterator();
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Object clone() {
        ResourceGroupQueue clone = null;
        try {
            clone = (ResourceGroupQueue)super.clone();
            if (this.queue != null) {
                clone.queue = new ArrayList<ResourceGroupQueueItem>();
                for (ResourceGroupQueueItem item : this.queue) {
                    ResourceGroupQueueItem cloneItem = (ResourceGroupQueueItem)item.clone();
                    clone.queue.add(cloneItem);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private String getGroupName() {
        String groupName = null;
        groupName = this.parentGroup == null ? "unknown resource group" : "resource group [" + this.parentGroup.getId() + "]";
        return groupName;
    }
}

