/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ExtendedTransition;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;
import org.jbpm.context.def.ContextDefinition;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.jpdl.xml.JpdlParser;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.xml.sax.InputSource;

public class WFSJpdlXmlReader
extends JpdlXmlReader {
    private static final long serialVersionUID = 582032965130984683L;
    private static final Logger logger = Logger.getLogger(WFSJpdlXmlReader.class);

    public WFSJpdlXmlReader(InputStream stream) {
        super(new InputSource(stream));
        this.unresolvedTransitionDestinations = new ArrayList();
        this.unresolvedActionReferences = new ArrayList();
        this.problems = new ArrayList();
    }

    public ProcessDefinition readProcessDefinition() {
        logger.debug((Object)"Reading process definition XML");
        Element root = null;
        try {
            root = JpdlParser.parse((InputSource)this.inputSource, (ProblemListener)this).getRootElement();
        }
        catch (Exception e) {
            throw new TemplateReaderException("Failed to parse the document", (Throwable)e);
        }
        String className = root.attributeValue("class", WorkflowTemplate.class.getName());
        logger.debug((Object)("Creating template of type " + className));
        try {
            this.processDefinition = (ProcessDefinition)Class.forName(className).newInstance();
            this.processDefinition.addDefinition((ModuleDefinition)new TaskMgmtDefinition());
            this.processDefinition.addDefinition((ModuleDefinition)new ContextDefinition());
            this.parseProcessDefinitionAttributes(root);
            this.readActions(root, null, null);
            this.readNodes(root, (NodeCollection)this.processDefinition);
            this.readEvents(root, (GraphElement)this.processDefinition);
            this.readExceptionHandlers(root, (GraphElement)this.processDefinition);
            this.readTasks(root, null);
            this.resolveTransitionDestinations();
            this.resolveActionReferences();
        }
        catch (ClassNotFoundException e) {
            this.addError("Failed to load class " + className, e);
        }
        catch (Throwable t) {
            this.addError("Failed to compile template", t);
        }
        if (Problem.containsProblemsOfLevel((Collection)this.problems, (int)2)) {
            throw new TemplateReaderException(this.problems);
        }
        return this.processDefinition;
    }

    protected void parseProtectionKeys(Element root) {
        IAuthorizationManager manager = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
        if (manager == null) {
            this.addError("Unable to get protection keys, service is unavailable");
            return;
        }
        List list = root.elements("protection-key");
        if (list == null || list.size() == 0) {
            return;
        }
        for (Element e : list) {
            String name = e.attributeValue("name");
            if (name == null || name.length() == 0) {
                this.addError("Protection key name must be specified");
                continue;
            }
            ProtectionKey key = manager.getProtectionKey(name);
            if (key == null) {
                key = new ProtectionKey(name);
                manager.addProtectionKey(key);
            }
            logger.debug((Object)("Adding protection key " + name));
            if (!(this.processDefinition instanceof WorkflowTemplate)) continue;
            ((WorkflowTemplate)this.processDefinition).addProtectionKey(key);
        }
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        super.readNode(nodeElement, node, nodeCollection);
        logger.debug((Object)("Read node " + node.getName()));
        Element child = nodeElement.element("resource-group");
        if (child != null) {
            this.readResourceGroup(child, node);
        }
    }

    protected void parseProcessDefinitionAttributes(Element root) {
        String version;
        super.parseProcessDefinitionAttributes(root);
        if (this.processDefinition instanceof Parsable) {
            ((Parsable)Parsable.class.cast(this.processDefinition)).read(root, (JpdlXmlReader)this);
        }
        if ((version = root.attributeValue("version")) == null || version.length() == 0) {
            this.addError("Template " + this.processDefinition.getName() + " must have a version");
        } else {
            this.processDefinition.setVersion(Integer.valueOf(version).intValue());
        }
        this.parseProtectionKeys(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readResourceGroup(Element element, Node node) {
        List groups;
        if (!(node instanceof ResourceGroupAware)) {
            return;
        }
        String name = element.attributeValue("name");
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ResourceGroup.class);
            groups = criteria.list();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        long id = -1L;
        for (ResourceGroup group : groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            id = group.getId();
            logger.debug((Object)("Found resource group " + id + " for " + name));
            if (!(node instanceof ResourceGroupAware)) break;
            ((ResourceGroupAware)node).setResourceGroupID(Long.valueOf(id));
            break;
        }
        if (id == -1L) {
            this.addError("Failed to find resource group " + name);
        }
    }

    public List readVariableAccesses(Element element) {
        ArrayList<TaskVariable> variables = new ArrayList<TaskVariable>();
        Iterator i = element.elementIterator("variable");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.attributeValue("name");
            String access = e.attributeValue("access", "read,write,required");
            String mappedName = e.attributeValue("mapped-name");
            String type = e.attributeValue("type", Datatype.STRING.toString());
            String initialValue = e.attributeValue("value", null);
            Datatype datatype = Datatype.valueOf((String)type);
            try {
                if (initialValue == null) {
                    variables.add(new TaskVariable(name, access, mappedName, datatype));
                } else {
                    variables.add(new TaskVariable(name, access, mappedName, datatype, initialValue));
                }
                logger.debug((Object)("Added variable " + name + " type " + datatype.toString()));
            }
            catch (TypeConversionException e1) {
                this.addError("Variable " + name + " - " + e1.getMessage(), e1);
            }
        }
        return variables;
    }

    public void resolveTransitionDestination(Element transitionElement, Node node) {
        ExtendedTransition transition = new ExtendedTransition();
        transition.setProcessDefinition(this.processDefinition);
        String name = transitionElement.attributeValue("name");
        if (name != null) {
            transition.setName(name);
        }
        node.addLeavingTransition((Transition)transition);
        String toName = transitionElement.attributeValue("to");
        if (toName == null) {
            this.addError("Node " + node.getName() + " has a transition without a destination node");
            return;
        }
        Node to = ((NodeCollection)node.getParent()).findNode(toName);
        if (to == null) {
            this.addError("Cannot make transition to non existent node " + toName + " from " + node.getName());
            return;
        }
        to.addArrivingTransition((Transition)transition);
        this.readActions(transitionElement, (GraphElement)transition, "transition");
    }

    protected void readEvents(Element parentElement, GraphElement graphElement) {
        for (Element e : parentElement.elements("event")) {
            String eventType = e.attributeValue("type");
            if (eventType == null || eventType.trim().length() == 0) {
                this.addError("Event type not specified for " + graphElement);
                continue;
            }
            if (!graphElement.hasEvent(eventType)) {
                graphElement.addEvent(new Event(eventType));
            }
            this.readActions(e, graphElement, eventType);
        }
    }
}

