/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing.generator;

import com.tandbergtv.workflow.core.licensing.generator.FileLicenseGenerator;
import com.tandbergtv.workflow.core.licensing.generator.ILicenseGenerator;
import com.tandbergtv.workflow.core.licensing.generator.LicenseNotGeneratedException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LicenseGenerator {
    private ILicenseGenerator licenseGenerator;
    private static final String CONFIG_PROPERTIES_FILE_PATH = "com/tandbergtv/workflow/core/licensing/generator/license-config.properties";
    private static final String FILE_NAME = "fileName";
    private static final String CLASS_NAME = "className";
    private static final String PASSWORD = "TandbergTelevisionPartOfTheEricssonGroup";
    private static Logger logger = Logger.getLogger(LicenseGenerator.class);

    public LicenseGenerator() throws LicenseNotGeneratedException {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(CONFIG_PROPERTIES_FILE_PATH);
        Properties prop = new Properties();
        try {
            prop.loadFromXML(inStream);
            String className = prop.getProperty(CLASS_NAME);
            if (className == null || className.trim().length() == 0) {
                throw new LicenseNotGeneratedException("The name of the license generator class file is not specified in com/tandbergtv/workflow/core/licensing/generator/license-config.properties");
            }
            Class<?> clazz = Class.forName(className);
            this.licenseGenerator = (ILicenseGenerator)clazz.newInstance();
            if (this.licenseGenerator instanceof FileLicenseGenerator) {
                String fileName = prop.getProperty(FILE_NAME);
                if (fileName == null || fileName.trim().length() == 0) {
                    throw new LicenseNotGeneratedException("The name of the license file is not specified in com/tandbergtv/workflow/core/licensing/generator/license-config.properties");
                }
                ((FileLicenseGenerator)this.licenseGenerator).setFileName(fileName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while initializing LicenseGenerator: ", (Throwable)e);
        }
    }

    public void generateAndSave() throws LicenseNotGeneratedException {
        this.licenseGenerator.generateAndSave(PASSWORD);
    }

    public static void main(String[] args) {
        try {
            LicenseGenerator generator = new LicenseGenerator();
            generator.generateAndSave();
            logger.info((Object)"License successfully generated");
        }
        catch (LicenseNotGeneratedException e) {
            logger.error((Object)"Exception while generating a license: ", (Throwable)e);
        }
    }
}

