/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.boot;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.PluginConfigurationLoader;
import com.tandbergtv.workflow.adaptor.internal.DefaultAdaptor;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import java.util.Map;
import org.apache.log4j.Logger;

class AdaptorFactory {
    private IMessageRegistry messages;
    private IAdaptorRegistry registry;
    private static final Logger logger = Logger.getLogger(AdaptorFactory.class);

    public AdaptorFactory() {
        ServiceRegistry services = ServiceRegistry.getDefault();
        this.registry = (IAdaptorRegistry)services.lookup(IAdaptorRegistry.class);
        this.messages = (IMessageRegistry)services.lookup(IMessageRegistry.class);
    }

    public void registerAdaptorFor(ResourceTypeDescriptor rt) {
        logger.debug((Object)("Descriptor : " + rt.getName()));
        for (String key : rt.getMessages().keySet()) {
            MessageDescriptor messageDesciptor = (MessageDescriptor)rt.getMessages().get(key);
            this.messages.addMessage(messageDesciptor.getUID(), messageDesciptor.getName());
        }
        AdaptorDescriptor descriptor = rt.getAdaptor();
        if (descriptor != null) {
            this.loadAdaptor(descriptor, rt, this.registry);
        }
    }

    private void loadAdaptor(AdaptorDescriptor descriptor, ResourceTypeDescriptor rt, IAdaptorRegistry registry) {
        String className = descriptor.getAdaptorClass();
        if (descriptor.isDefault()) {
            this.updateDefaultAdaptor(descriptor, rt, (DefaultAdaptor)registry.getDefaultAdaptor());
        } else {
            try {
                IAdaptor a = this.getAdaptor(className, rt.getClassLoader(), descriptor.getProperties());
                registry.registerAdaptor(className, a);
            }
            catch (AdaptorException e) {
                logger.error((Object)("Error registering adaptor class " + className), (Throwable)e);
            }
        }
    }

    private void updateDefaultAdaptor(AdaptorDescriptor descriptor, ResourceTypeDescriptor rt, DefaultAdaptor adaptor) {
        ClassLoader cl = rt.getClassLoader();
        String className = descriptor.getMessageIdentifierClass();
        if (className != null && className.length() > 0) {
            try {
                logger.debug((Object)("Adding message identifier class " + className));
                IMessageIdentifier id = this.getMessageIdentifier(className, cl);
                adaptor.addMessageIDClass(id);
            }
            catch (AdaptorException e) {
                logger.error((Object)("Error adding message identifier class " + className), (Throwable)e);
            }
        }
        Map messages = rt.getMessages();
        for (String key : messages.keySet()) {
            MessageDescriptor messageDesciptor = (MessageDescriptor)messages.get(key);
            MessageUIDImpl uid = new MessageUIDImpl(messageDesciptor.getUID());
            IMessageProcessorConfiguration conf = new PluginConfigurationLoader().getConfiguration(cl, (IMessageUID)uid);
            logger.debug((Object)("Adding configuration for UID " + uid));
            adaptor.addConfiguration((IMessageUID)uid, conf);
        }
    }

    private IAdaptor getAdaptor(String className, ClassLoader classLoader, Map<String, String> properties) throws AdaptorException {
        IAdaptor adaptor;
        try {
            logger.debug((Object)("Registering adaptor:" + className));
            Class<?> idClass = classLoader.loadClass(className);
            adaptor = (IAdaptor)idClass.newInstance();
            adaptor.init((IAdaptorConfiguration)new AdaptorConfigurationImpl(properties));
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Adaptor class " + className + " not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of adaptor class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of adaptor " + className, (Throwable)e);
        }
        return adaptor;
    }

    private IMessageIdentifier getMessageIdentifier(String className, ClassLoader classLoader) throws AdaptorException {
        IMessageIdentifier id;
        try {
            Class<?> idClass = classLoader.loadClass(className);
            id = (IMessageIdentifier)idClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Message identifier class " + className + " not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, (Throwable)e);
        }
        return id;
    }
}

