/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.monitor.AlertSystemHealthManager;
import com.tandbergtv.workflow.monitor.ISystemMonitor;
import com.tandbergtv.workflow.monitor.SystemMonitor;
import com.tandbergtv.workflow.monitor.event.EventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.ServiceLifecycleListener;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class Activator {
    public static final String SYSTEM_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=System";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        this.addService(new EventHandlerRegistry());
        this.addService(new ServiceLifecycleListener());
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(new SystemMonitor(), ISystemMonitor.class);
            server.registerMBean(mbean, new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
            WorkflowLogManager log = new WorkflowLogManager(HibernateUtil.getSessionFactory());
            ServiceRegistry.getDefault().register(log.getServiceName(), (Service)log);
            log.start();
            AlertSystemHealthManager.getInstance().initialize();
        }
        catch (JMException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
    }

    public void stop() {
        AlertSystemHealthManager.getInstance().shutdown();
        this.removeService(WorkflowLogManager.class);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"System monitor MBean unregistration failed");
        }
        this.removeService(ServiceLifecycleListener.class);
        this.removeService(IEventHandlerRegistry.class);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

