/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.watchpoint.boot.Platform;
import com.tandbergtv.workflow.monitor.HostAddress;
import com.tandbergtv.workflow.monitor.ISystemMonitor;

public class SystemMonitor
implements ISystemMonitor {
    private long epoch;
    private ISystemMonitor.State state = ISystemMonitor.State.OFFLINE;

    public SystemMonitor() {
        this.epoch = System.currentTimeMillis();
        if (HostAddress.match()) {
            this.state = ISystemMonitor.State.ONLINE;
        }
    }

    @Override
    public long getUptime() {
        return System.currentTimeMillis() - this.epoch;
    }

    @Override
    public ISystemMonitor.State getState() {
        return this.state;
    }

    @Override
    public void reload() {
        Platform platform = Platform.getPlatform();
        platform.stop();
        platform.start();
    }
}

