/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.boot;

import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import org.hibernate.SessionFactory;

public class Activator {
    public void start() {
        int system = this.getMaxResourceCount(LicenseKeyConstants.SYSTEM_RESOURCES);
        int human = this.getMaxResourceCount(LicenseKeyConstants.HUMAN_RESOURCE);
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
        ResourceManager rm = new ResourceManager(new ResourceManagerContext(sessionFactory, system, human));
        rm.start();
        ServiceRegistry.getDefault().register("ResourceManager", (Service)rm);
    }

    public void stop() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ResourceManagement rm = (ResourceManagement)registry.lookup(ResourceManagement.class);
        if (rm != null) {
            registry.unregister((Service)rm);
            rm.stop();
        }
    }

    private int getMaxResourceCount(String category) {
        int result = Integer.MAX_VALUE;
        LicenseManager lm = LicenseManager.getInstance();
        try {
            String string = lm.getObject(category);
            if (string == null || string.trim().length() == 0) {
                return result;
            }
            result = Integer.parseInt(string.trim());
            if (result < 0) {
                throw new RuntimeException("Invalid license - " + category + " must be a positive value");
            }
        }
        catch (InvalidLicenseException e) {
            throw new RuntimeException("Invalid license", e);
        }
        return result;
    }
}

