/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.monitor.ClusterConfiguration;
import com.tandbergtv.workflow.monitor.ISystemMonitor;
import com.tandbergtv.workflow.monitor.SystemMonitor;
import com.tandbergtv.workflow.monitor.event.EventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.monitor.event.ServiceLifecycleListener;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class Activator {
    private static final String CLUSTER_PROPERTIES = "cluster.properties";
    public static final String SYSTEM_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=System";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        this.addService(new EventHandlerRegistry());
        this.addService(new ServiceLifecycleListener());
        this.joinCluster();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(new SystemMonitor(), ISystemMonitor.class);
            server.registerMBean(mbean, new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
            WorkflowLogManager log = new WorkflowLogManager(HibernateUtil.getSessionFactory());
            ServiceRegistry.getDefault().register(log.getServiceName(), (Service)log);
            log.start();
        }
        catch (JMException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
    }

    public void stop() {
        this.removeService(WorkflowLogManager.class);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
        }
        catch (JMException e) {
            logger.warn((Object)"System monitor MBean unregistration failed");
        }
        this.removeService(ServiceLifecycleListener.class);
        this.removeService(IEventHandlerRegistry.class);
        this.leaveCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinCluster() {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            File file = new File(ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath"), CLUSTER_PROPERTIES);
            if (file.exists()) {
                is = new FileInputStream(file);
                properties.load(is);
            }
            Config config = ClusterConfiguration.create(properties);
            Hazelcast.init((Config)config);
            Cluster cluster = Hazelcast.getCluster();
            cluster.addMembershipListener(new MembershipListener(){

                public void memberRemoved(MembershipEvent e) {
                    logger.warn((Object)e.getMember().getInetSocketAddress());
                }

                public void memberAdded(MembershipEvent e) {
                    logger.info((Object)e.getMember().getInetSocketAddress());
                }
            });
        }
        catch (IOException e1) {
            logger.warn((Object)"Cannot join cluster", (Throwable)e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void leaveCluster() {
        Hazelcast.getLifecycleService().shutdown();
        Hazelcast.shutdownAll();
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

