/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.monitor;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.pluginmanager.event.PluginChangeEvent;
import com.tandbergtv.workflow.pluginmanager.event.PluginChangeEventType;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class PluginMonitorProcess
implements IProcess {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());

    public void fileCreated(FileInfo fileInfo) {
        this.handleChange(fileInfo, PluginChangeEventType.CREATE);
    }

    public void fileUpdated(FileInfo fileInfo) {
        this.handleChange(fileInfo, PluginChangeEventType.UPDATE);
    }

    public void fileDeleted(FileInfo fileInfo) {
    }

    private void handleChange(FileInfo fileInfo, PluginChangeEventType changeType) {
        String path = fileInfo.getAbsolutePath();
        File file = new File(path);
        Date timestamp = new Date();
        try {
            long startTime;
            long lastModified;
            if (file.isDirectory() && (lastModified = file.lastModified()) > (startTime = this.getStartTime())) {
                this.sendChangeEvent(new PluginChangeEvent((Object)this, path, changeType, timestamp));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failure handling plugin " + changeType + " event for path: " + path), (Throwable)e);
        }
    }

    private long getStartTime() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        long startTime = Long.MAX_VALUE;
        try {
            ObjectName name = new ObjectName("com.tandbergtv.watchpoint:type=System");
            Long uptime = (Long)server.getAttribute(name, "Uptime");
            startTime = System.currentTimeMillis() - uptime;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure getting application uptime.", (Throwable)e);
        }
        return startTime;
    }

    private void sendChangeEvent(PluginChangeEvent event) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
    }
}

