/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.hibernate.WorkflowNodeLogHDAO;
import com.tandbergtv.workflow.log.loggers.AbstractLogger;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.EventObject;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Document;

public class WorkflowMessageLogger
extends AbstractLogger {
    private static final Logger logger = Logger.getLogger(WorkflowMessageLogger.class);

    public WorkflowMessageLogger(SessionFactory sessionFactory, Integer count) {
        super(sessionFactory, count);
    }

    @Override
    public boolean match(EventObject logEvent, int index) {
        if (!(logEvent instanceof WorkflowMessageLogEvent)) {
            return false;
        }
        WorkflowMessageLogEvent event = (WorkflowMessageLogEvent)((Object)WorkflowMessageLogEvent.class.cast(logEvent));
        return event.getToken().getProcessInstance().getId() % (long)this.count == (long)index;
    }

    @Override
    public void execute(EventObject eventObj) {
        if (!(eventObj instanceof WorkflowMessageLogEvent)) {
            return;
        }
        WorkflowMessageLogEvent messageLogEvent = (WorkflowMessageLogEvent)((Object)eventObj);
        if (!messageLogEvent.isTrace()) {
            logger.debug((Object)(messageLogEvent.getToken() + " not being traced, event ignored."));
            return;
        }
        WorkflowMessageLog messageLog = null;
        try {
            messageLog = this.getMessageLog(messageLogEvent);
        }
        catch (Exception e) {
            logger.error((Object)("Exception while getting message log from message log event. Log event ignored. Message Log Event: " + (Object)((Object)messageLogEvent)), (Throwable)e);
            return;
        }
        Token token = messageLog.getToken();
        Node node = messageLog.getNode();
        if (node.getSuperState() != null) {
            node = node.getSuperState();
        }
        long start = System.currentTimeMillis();
        WorkflowNodeLog workflowNodeLog = this.getCurrentWorkflowNodeLog(node, token);
        long read = System.currentTimeMillis() - start;
        if (workflowNodeLog == null) {
            workflowNodeLog = new WorkflowNodeLog(token, node);
            workflowNodeLog.setDate(messageLog.getTimestamp());
            logger.debug((Object)("Storing workflow node log to database. Workflow Node Log: " + (Object)((Object)workflowNodeLog)));
            this.save((Object)workflowNodeLog);
        }
        messageLog.setNodeLog(workflowNodeLog);
        logger.debug((Object)("Storing message log to database. Message Log: " + messageLog));
        this.save(messageLog);
        long write = System.currentTimeMillis() - start;
        logger.debug((Object)("Read delay " + (double)read / 1000.0 + ", total delay " + (double)write / 1000.0));
    }

    private WorkflowMessageLog getMessageLog(WorkflowMessageLogEvent messageLogEvent) throws Exception {
        WorkflowMessage wfsMessage = messageLogEvent.getWfsMessage();
        Document document = Marshaller.newMarshaller().marshal(wfsMessage);
        String content = XMLDocumentUtility.convertToString(document);
        IMessageRegistry registry = (IMessageRegistry)ServiceRegistry.getDefault().lookup(IMessageRegistry.class);
        String uid = wfsMessage.getMessageUID().getUID();
        IMessageUID messageUID = registry != null ? registry.getMessageUID(uid) : null;
        String name = messageUID != null ? messageUID.getName() : null;
        WorkflowMessageLog messageLog = new WorkflowMessageLog(wfsMessage.getMessageUID().getUID(), wfsMessage.getType().name(), name, content, messageLogEvent.isIncoming(), messageLogEvent.getTimestamp(), messageLogEvent.getResource());
        messageLog.setNode(messageLogEvent.getNode());
        messageLog.setToken(messageLogEvent.getToken());
        return messageLog;
    }

    private WorkflowNodeLog getCurrentWorkflowNodeLog(Node node, Token token) {
        WorkflowNodeLogHDAO workflowNodeLogDAO = new WorkflowNodeLogHDAO((Session)this.sessionFactory.getCurrentSession());
        WorkflowNodeLog wnl = workflowNodeLogDAO.findCurrentByTokenAndNode(token, node);
        logger.debug((Object)("Corresponding workflow node log for node: [" + node + "] and token: [" + token + "] is: [" + (Object)((Object)wnl) + "]"));
        return wnl;
    }
}

