/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.watch.AbstractFileListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.jbpm.graph.def.ProcessDefinition;

public class TemplateListener
extends AbstractFileListener {
    @Override
    public void fileCreated(FileInfo fileInfo) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        File file = new File(fileInfo.getAbsolutePath());
        String dir = file.getParentFile().getParentFile() + File.separator;
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        String name = File.separator + file.getName().replace(".", "-") + "-" + time + ".xml";
        this.preCreate(file);
        ITemplateLoaderService loader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
        for (WorkflowTemplate t : loader.getLatestTemplates()) {
            if (!t.getName().equals("Template Watcher")) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("path", fileInfo.getAbsolutePath());
            parameters.put("imported", dir + "imported" + name);
            parameters.put("rejected", dir + "rejected" + name);
            IProcessManagerService service = (IProcessManagerService)registry.lookup(IProcessManagerService.class);
            try {
                CustomToken token = service.create((ProcessDefinition)t, parameters);
                service.start(token);
                break;
            }
            catch (DriverException e) {
                throw new RuntimeException("Process create failed", e);
            }
        }
    }

    @Override
    public void fileDeleted(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fileUpdated(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected WorkflowTemplate read(File file) {
        throw new UnsupportedOperationException();
    }
}

