/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.registry;

import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MessageRegistry
implements IMessageRegistry {
    private Map<String, String> messages;
    private static MessageRegistry instance;
    private static final Lock lock;
    private static final Logger logger;

    private MessageRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageRegistry getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new MessageRegistry();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(String uid, String name) {
        lock.lock();
        try {
            logger.debug((Object)("Adding message with uid " + uid + " and name " + name));
            this.messages.put(uid, name);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public IMessageUID getMessageUID(String uid) {
        if (this.messages.get(uid) == null) {
            return null;
        }
        return new MessageUIDImpl(uid, this.messages.get(uid));
    }

    public void start() {
        this.messages = new HashMap<String, String>();
    }

    public void stop() {
        this.messages.clear();
    }

    public String getServiceName() {
        return "Message Registry";
    }

    static {
        lock = new ReentrantLock();
        logger = Logger.getLogger(MessageRegistry.class);
    }
}

