/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.allocation;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MostRemainingConnectionsResourceAllocationStrategy
implements ResourceAllocationStrategy {
    private static final long serialVersionUID = -4134956257257787514L;

    @Override
    public Resource allocateResource(ResourceGroup resourceGroup) {
        Resource allocatedResource = null;
        ArrayList<Resource> resources = new ArrayList<Resource>(resourceGroup.getResources());
        Collections.sort(resources, new ResourceAvailabilityComparator());
        for (Resource resource : resources) {
            if (!AllocationUtility.isResourceAvailable(resource)) continue;
            allocatedResource = resource;
            break;
        }
        return allocatedResource;
    }

    class ResourceAvailabilityComparator
    implements Comparator<Resource> {
        ResourceAvailabilityComparator() {
        }

        @Override
        public int compare(Resource resource1, Resource resource2) {
            int maxUsers1 = resource1.getMaxConcurrentUsers() == 0 ? Integer.MAX_VALUE : resource1.getMaxConcurrentUsers();
            int maxUsers2 = resource2.getMaxConcurrentUsers() == 0 ? Integer.MAX_VALUE : resource2.getMaxConcurrentUsers();
            Integer availableSlots1 = maxUsers1 - resource1.getUserCount();
            Integer availableSlots2 = maxUsers2 - resource2.getUserCount();
            return availableSlots1.compareTo(availableSlots2);
        }
    }
}

