/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.DatatypeConverter;
import com.tandbergtv.workflow.driver.internal.TypeConversionException;
import com.tandbergtv.workflow.driver.internal.monitor.CumulativeStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.Statistics;
import com.tandbergtv.workflow.driver.internal.monitor.TokenStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.plugin.ICreateDelegate;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;

public class ProcessManager
implements IProcessManagerService {
    private ISchedulerService<CustomToken> scheduler;
    private ISchedulerService<Void> globalScheduler;
    private static final String SERVICE_NAME = "Process Manager";
    private boolean initialized;
    private Properties properties;
    private IStatistics statistics;
    private static final Long EMA_CALCULATION_PERIOD = 500L;
    private static String DRIVER_HALTED_PROPERTY = "isDriverHalted";
    private static final Logger logger = Logger.getLogger(ProcessManager.class);

    public ProcessManager(Properties properties) {
        DefaultMediator.getInstance().register((IColleague)this);
        this.globalScheduler = new Scheduler("process-runtime", 1, 1);
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".service");
        double maxCreateRate = Double.parseDouble(bundle.getString("max.create.rate"));
        double factor = Double.parseDouble(bundle.getString("history.factor"));
        CumulativeStatistics cumulative = new CumulativeStatistics(maxCreateRate, factor, EMA_CALCULATION_PERIOD);
        ProcessStatistics current = new ProcessStatistics(this.getSearchService());
        TokenStatistics branches = new TokenStatistics(this.getTokenSearchService());
        this.statistics = new Statistics(current, cumulative, branches);
        int core = Integer.parseInt(bundle.getString("scheduler.pool.size"));
        int max = Integer.parseInt(bundle.getString("scheduler.pool.max"));
        this.scheduler = new Scheduler("token-thread", core, max);
        this.properties = properties;
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(IStatistics statistics) {
        this.statistics = statistics;
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.statistics.getCumulativeStatistics());
    }

    @Override
    public CustomToken create(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        return this.create(template, ProcessPriority.NORMAL, parameters);
    }

    @Override
    public CustomToken create(ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) throws DriverException {
        Map<String, Object> copy = this.getInitialVariables(template, parameters);
        this.preCreate(template, copy);
        WorkflowProcess process = new WorkflowProcess(template, priority);
        for (String name : copy.keySet()) {
            process.getContextInstance().setVariable(name, copy.get(name));
        }
        this.postCreate(process);
        return process.getRootToken();
    }

    @Override
    public CustomToken create(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        Map<String, Object> copy = this.getInitialVariables(template, parameters);
        this.preCreate(template, copy);
        WorkflowProcess process = token.createSubProcessInstance(template);
        for (String name : copy.keySet()) {
            process.getContextInstance().setVariable(name, copy.get(name));
        }
        this.postCreate(process);
        return process.getRootToken();
    }

    protected Map<String, Object> getInitialVariables(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        DatatypeConverter converter = DatatypeConverter.getInstance();
        for (TaskVariable variable : this.getStartTaskVariables(template)) {
            Datatype datatype = variable.getDatatype();
            String key = variable.getVariableName();
            Object value = parameters.get(key);
            if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
                if (variable.isRequired()) {
                    throw new DriverException("Required variable (" + key + ") is not defined");
                }
                value = this.getDefaultValue(datatype);
            }
            if (value == null) continue;
            try {
                copy.put(key, converter.convert(value, datatype));
            }
            catch (TypeConversionException e) {
                throw new DriverException("Input value data type mismatch", e);
            }
        }
        return copy;
    }

    protected void preCreate(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        ICreateDelegate delegate = (ICreateDelegate)this.getCallback("driver.create.delegate");
        if (delegate != null) {
            delegate.create(template, parameters);
        }
    }

    protected void postCreate(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).create(process);
        this.getCounter().created(process.getRootToken());
    }

    @Override
    public Future<CustomToken> start(final CustomToken token) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    if (ProcessManager.this.getIsHalted()) {
                        token.suspend();
                        ProcessManager.this.getCounter().paused(token);
                    } else {
                        token.start();
                        ProcessManager.this.getCounter().started(token);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> pause(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.suspend();
                ProcessManager.this.getCounter().paused(token);
                return token;
            }
        });
    }

    @Override
    public Collection<Future<CustomToken>> pause(Collection<CustomToken> tokens) {
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken token : tokens) {
            futures.add(this.pause(token));
        }
        return futures;
    }

    @Override
    public Future<CustomToken> resume(final CustomToken token) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    token.resume();
                    ProcessManager.this.getCounter().resumed(token);
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> restart(final Serializable id) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                WorkflowProcess process = ((IPersistenceService)registry.lookup(IPersistenceService.class)).get(id);
                WorkflowTemplate template = process.getProcessDefinition();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (TaskVariable variable : ProcessManager.this.getStartTaskVariables((ProcessDefinition)template)) {
                    String name = variable.getVariableName();
                    Object value = process.getContextInstance().getVariable(name);
                    parameters.put(name, value);
                }
                CustomToken token = ProcessManager.this.create((ProcessDefinition)template, process.getPriority(), parameters);
                ProcessManager.this.start(token);
                ProcessManager.this.getCounter().restarted();
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> dequeue(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    token.dequeue();
                    ProcessManager.this.getCounter().dequeued(token);
                }
                catch (Throwable t) {
                    logger.error((Object)token, t);
                }
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> cancel(final CustomToken token) {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.cancel();
                ProcessManager.this.getCounter().cancelled(token);
                return token;
            }
        });
    }

    @Override
    public Collection<Future<CustomToken>> cancel(Collection<CustomToken> tokens) {
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken token : tokens) {
            futures.add(this.cancel(token));
        }
        return futures;
    }

    @Override
    public Future<CustomToken> delete(final WorkflowProcess process) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                process.delete();
                ProcessManager.this.getCounter().deleted(process.getRootToken());
                return process.getRootToken();
            }
        });
    }

    @Override
    public Future<Void> pause() throws DriverException {
        return this.globalScheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws DriverException {
                logger.info((Object)"Suspending...");
                ProcessManager.this.setIsHalted(true);
                for (WorkflowProcess process : ProcessManager.this.getSearchService().findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED)) {
                    ProcessManager.this.pause(process.getRootToken());
                }
                return null;
            }
        });
    }

    @Override
    public Future<Void> resume() throws DriverException {
        return this.globalScheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws DriverException {
                logger.info((Object)"Resuming...");
                ProcessManager.this.setIsHalted(false);
                List<WorkflowProcess> processes = ProcessManager.this.getSearchService().findAllByStatus(ProcessStatus.PAUSED);
                Collections.sort(processes, new Comparator<WorkflowProcess>(){

                    @Override
                    public int compare(WorkflowProcess p1, WorkflowProcess p2) {
                        if (p1.getPriority() == p2.getPriority()) {
                            return p2.getStart().getTime() > p1.getStart().getTime() ? -1 : (p2.getStart().getTime() == p1.getStart().getTime() ? 0 : 1);
                        }
                        return p2.getPriority().compareTo((Enum)p1.getPriority());
                    }
                });
                for (WorkflowProcess process : processes) {
                    ProcessManager.this.resume(process.getRootToken());
                }
                return null;
            }
        });
    }

    @Override
    public void setPriority(WorkflowProcess process, ProcessPriority priority) {
        process.setPriority(priority);
        CustomToken rootToken = process.getRootToken();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, (Token)rootToken, WorkflowProcessEventType.PRIORITY_CHANGED));
        for (Token token : rootToken.getActiveChildTokens()) {
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, token, WorkflowProcessEventType.PRIORITY_CHANGED));
        }
    }

    public String getColleagueName() {
        return SERVICE_NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof ServiceEvent) || this.initialized) {
            return;
        }
        ServiceEvent e = (ServiceEvent)ServiceEvent.class.cast(event);
        if (e.getService().getServiceName() == "ResourceManager" && e.getEvent() == ServiceEvents.STARTED) {
            this.start();
        }
    }

    public void start() {
        logger.info((Object)"Starting process manager service...");
        final IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.globalScheduler.start();
        this.scheduler.start();
        this.globalScheduler.schedule((Callable)new CrashRecoveryThread());
        this.globalScheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)ProcessManager.this, ServiceEvents.STARTED));
                logger.info((Object)"Process manager service started");
                return null;
            }
        });
        this.globalScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ProcessManager.this.getCounter().recalculateCreateRate();
            }
        }, 0L, EMA_CALCULATION_PERIOD.longValue());
        this.initialized = true;
    }

    public void stop() {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        this.scheduler.stop();
        this.globalScheduler.stop();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        this.initialized = false;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private Future<CustomToken> schedule(Callable<CustomToken> callable) {
        Future future = null;
        try {
            future = this.scheduler.schedule(callable);
        }
        catch (RejectedExecutionException e) {
            logger.warn((Object)("Could not add scheduled task to " + this.scheduler.getServiceName()), (Throwable)e);
        }
        return future;
    }

    private boolean getIsHalted() {
        String haltedValue = this.properties.getProperty(DRIVER_HALTED_PROPERTY);
        return Boolean.parseBoolean(haltedValue);
    }

    private void setIsHalted(boolean isHalted) {
        block13: {
            String value = Boolean.toString(isHalted);
            this.properties.setProperty(DRIVER_HALTED_PROPERTY, value);
            OutputStream out = null;
            String name = this.properties.getProperty("driver.properties.file");
            try {
                try {
                    if (name != null) {
                        out = new FileOutputStream(new File(name));
                        this.properties.store(out, null);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to save the halted state", (Throwable)e);
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Failed to close the properties file", (Throwable)ex);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Failed to close the properties file", (Throwable)ex);
                    }
                }
            }
        }
    }

    private Object getDefaultValue(Datatype type) {
        Object value = null;
        switch (type) {
            case STRING: {
                value = "";
                break;
            }
            case BOOLEAN: {
                value = Boolean.FALSE;
                break;
            }
            case INT: {
                value = 0;
                break;
            }
            case FILE: {
                value = "";
                break;
            }
            case URL: {
                value = "";
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private List<TaskVariable> getStartTaskVariables(ProcessDefinition template) {
        Task t = template.getTaskMgmtDefinition().getStartTask();
        if (t == null) {
            return new ArrayList<TaskVariable>();
        }
        return t.getTaskController().getVariableAccesses();
    }

    private Object getCallback(String id) {
        Object callback = null;
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".service");
        String className = bundle.getString(id);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            callback = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DriverRuntimeException("Failed to load delegate", e);
        }
        return callback;
    }

    private IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    private ITokenSearchService getTokenSearchService() {
        return (ITokenSearchService)ServiceRegistry.getDefault().lookup(ITokenSearchService.class);
    }

    private final class CrashRecoveryThread
    implements Callable<Void> {
        private CrashRecoveryThread() {
        }

        @Override
        public Void call() throws Exception {
            IMediator mediator = DefaultMediator.getInstance();
            Collection<WorkflowProcess> processes = this.search();
            logger.info((Object)("Performing crash recovery for " + processes.size() + " process(es)"));
            for (WorkflowProcess process : processes) {
                for (final CustomToken token : process.findAllTokens()) {
                    if (token.getStatus() != ProcessStatus.QUEUED) continue;
                    this.cache(process);
                    mediator.sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, (Token)token, WorkflowProcessEventType.CACHE_INITED));
                }
            }
            for (WorkflowProcess process : processes) {
                ResourceGroupAware aware;
                CustomToken token;
                token = process.getRootToken();
                if (token.getStatus() == ProcessStatus.BRANCHED) {
                    this.cache(process);
                }
                if (ResourceGroupAware.class.isAssignableFrom(token.getCurrentNode().getClass()) && (aware = (ResourceGroupAware)token.getCurrentNode()).getResourceGroupID() != null) {
                    try {
                        token.recover();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)(token + ", failed to recover"), t);
                    }
                    continue;
                }
                ProcessManager.this.schedule(new Callable<CustomToken>(){

                    @Override
                    public CustomToken call() {
                        try {
                            token.recover();
                        }
                        catch (Throwable t) {
                            logger.warn((Object)(token + ", failed to recover"), t);
                        }
                        return token;
                    }
                });
            }
            return null;
        }

        private Collection<WorkflowProcess> search() {
            return ProcessManager.this.getSearchService().findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED);
        }

        private void cache(WorkflowProcess process) {
            ServiceRegistry registry = ServiceRegistry.getDefault();
            ICacheService cache = (ICacheService)registry.lookup("Process Cache");
            cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
        }
    }
}

