/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.EventHandler;
import com.tandbergtv.workflow.driver.internal.callable.CancelToken;
import com.tandbergtv.workflow.driver.internal.callable.DequeToken;
import com.tandbergtv.workflow.driver.internal.callable.OneShotTokenCallable;
import com.tandbergtv.workflow.driver.internal.callable.PauseToken;
import com.tandbergtv.workflow.driver.internal.callable.RecoverToken;
import com.tandbergtv.workflow.driver.internal.callable.ResumeToken;
import com.tandbergtv.workflow.driver.internal.callable.StartToken;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.internal.monitor.CumulativeStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatistics;
import com.tandbergtv.workflow.driver.internal.monitor.Statistics;
import com.tandbergtv.workflow.driver.internal.monitor.TokenStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class ProcessManager
implements IProcessManagerService {
    private ISchedulerService<CustomToken> scheduler;
    private ISchedulerService<Void> globalScheduler;
    private EventHandler eventhandler = new EventHandler();
    private static final String SERVICE_NAME = "Process Manager";
    private boolean initialized;
    private Properties properties;
    private IStatistics statistics;
    private static final Long EMA_CALCULATION_PERIOD = 500L;
    private static final Logger logger = Logger.getLogger(ProcessManager.class);

    public ProcessManager(Properties properties) {
        DefaultMediator.getInstance().register((IColleague)this.eventhandler);
        this.globalScheduler = new Scheduler("process-runtime", 1, 1);
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".service");
        double maxCreateRate = Double.parseDouble(bundle.getString("max.create.rate"));
        double factor = Double.parseDouble(bundle.getString("history.factor"));
        CumulativeStatistics cumulative = new CumulativeStatistics(maxCreateRate, factor, EMA_CALCULATION_PERIOD);
        ProcessStatistics current = new ProcessStatistics(this.getSearchService());
        TokenStatistics branches = new TokenStatistics(this.getTokenSearchService());
        this.statistics = new Statistics(current, cumulative, branches);
        int core = Integer.parseInt(bundle.getString("scheduler.pool.size"));
        int max = Integer.parseInt(bundle.getString("scheduler.pool.max"));
        this.scheduler = new Scheduler("token-thread", core, max);
        this.properties = properties;
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.statistics.getCumulativeStatistics());
    }

    @Override
    public Future<CustomToken> start(CustomToken token) throws DriverException {
        return this.callAndForget(new StartToken(token));
    }

    @Override
    public Future<CustomToken> pause(CustomToken token) {
        return this.call(new PauseToken(token));
    }

    @Override
    public Future<CustomToken> resume(CustomToken token) throws DriverException {
        return this.call(new ResumeToken(token));
    }

    @Override
    public Future<CustomToken> restart(final Serializable id) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                WorkflowProcess process = ((IPersistenceService)registry.lookup(IPersistenceService.class)).get(id);
                WorkflowTemplate template = process.getProcessDefinition();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (TaskVariable variable : template.getStartTaskVariables()) {
                    if (!variable.isRequired()) continue;
                    String name = variable.getVariableName();
                    Object value = process.getContextInstance().getVariable(name);
                    parameters.put(name, value);
                }
                IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
                CustomToken token = factory.create((ProcessDefinition)template, process.getPriority(), parameters).getRootToken();
                ProcessManager.this.start(token);
                ProcessManager.this.getCounter().restarted();
                return token;
            }
        });
    }

    @Override
    public Future<CustomToken> dequeue(CustomToken token) {
        return this.schedule(new DequeToken(token));
    }

    @Override
    public Future<CustomToken> recover(CustomToken token) {
        return this.call(new RecoverToken(token));
    }

    @Override
    public Future<CustomToken> cancel(CustomToken token) {
        return this.call(new CancelToken(token));
    }

    @Override
    public Future<CustomToken> delete(final WorkflowProcess process) throws DriverException {
        return this.schedule(new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                process.delete();
                ProcessManager.this.getCounter().deleted(process.getRootToken());
                return process.getRootToken();
            }
        });
    }

    @Override
    public Future<Void> recover() {
        return this.globalScheduler.schedule((Callable)new CrashRecovery());
    }

    @Override
    public void setPriority(WorkflowProcess process, ProcessPriority priority) {
        process.setPriority(priority);
        CustomToken rootToken = process.getRootToken();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, (Token)rootToken, WorkflowProcessEventType.PRIORITY_CHANGED));
        for (Token token : rootToken.getActiveChildTokens()) {
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, token, WorkflowProcessEventType.PRIORITY_CHANGED));
        }
    }

    @Override
    public ISchedulerService<CustomToken> getScheduler() {
        return this.scheduler;
    }

    public void start() {
        if (this.initialized) {
            return;
        }
        logger.debug((Object)"Starting process manager service...");
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.globalScheduler.start();
        this.scheduler.start();
        this.globalScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ProcessManager.this.getCounter().recalculateCreateRate();
            }
        }, 0L, EMA_CALCULATION_PERIOD.longValue());
        this.initialized = true;
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
        logger.info((Object)"Process manager service started");
    }

    public void stop() {
        if (!this.initialized) {
            return;
        }
        IMediator mediator = DefaultMediator.getInstance();
        mediator.unregister((IColleague)this.eventhandler);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        this.scheduler.stop();
        this.globalScheduler.stop();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        this.initialized = false;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private Future<CustomToken> schedule(Callable<CustomToken> callable) {
        return this.scheduler.schedule(callable);
    }

    private Future<CustomToken> call(TokenCallable callable) {
        ISchedulerService executor = (ISchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
        return executor.schedule((Callable)((Object)callable));
    }

    private Future<CustomToken> callAndForget(OneShotTokenCallable callable) {
        ISchedulerService executor = (ISchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        return executor.schedule((Callable)((Object)callable));
    }

    private IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    private ITokenSearchService getTokenSearchService() {
        return (ITokenSearchService)ServiceRegistry.getDefault().lookup(ITokenSearchService.class);
    }

    private final class CrashRecovery
    implements Callable<Void> {
        private CrashRecovery() {
        }

        @Override
        public Void call() throws Exception {
            Collection<WorkflowProcess> processes = this.search();
            HashSet<WorkflowProcess> pending = new HashSet<WorkflowProcess>();
            logger.info((Object)("Performing crash recovery for " + processes.size() + " process(es)"));
            for (WorkflowProcess process : processes) {
                if (process.getSuperProcessToken() != null) {
                    pending.add(process);
                    continue;
                }
                ProcessManager.this.recover(process.getRootToken());
            }
            for (WorkflowProcess process : pending) {
                ProcessManager.this.recover(process.getRootToken());
            }
            return null;
        }

        private Collection<WorkflowProcess> search() {
            return ProcessManager.this.getSearchService().findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED);
        }
    }
}

