/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;

public class ExtendedTransition
extends Transition {
    private static final long serialVersionUID = 1256972723858185546L;

    public ExtendedTransition() {
    }

    public ExtendedTransition(String name) {
        super(name);
    }

    public void take(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        if (token.hasParent() && token.getParent().getRequestedStatus() != ProcessStatus.BRANCHED) {
            return;
        }
        token.setNode(this.to);
        this.to.setProcessDefinition((ProcessDefinition)token.getProcessInstance().getProcessDefinition());
        if (!token.isResuming()) {
            SuperState parent = context.getTransitionSource().getSuperState();
            if (parent != null && !parent.containsNode(this.to)) {
                parent.leave(context);
            }
        } else {
            token.setResuming(false);
        }
        this.fireEvent("transition", context);
        if (token.getStatus() == ProcessStatus.RUNNING) {
            this.to.enter(context);
        }
    }
}

