/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.TypeConversionException;
import org.jbpm.context.def.VariableAccess;

public class TaskVariable
extends VariableAccess {
    private static final long serialVersionUID = -3920818381338217077L;
    public static final String ACCESS_LITERAL_WOKEY = "woKey";
    public static final String ACCESS_LITERAL_SHOW_IN_UI = "showInUI";
    private static final String ACCESS_ATTACHMENT = "attachment";
    private Datatype datatype;
    private String initialValue;

    public TaskVariable() {
    }

    public TaskVariable(String variableName, String access, String mappedName, Datatype datatype) {
        super(variableName, access, mappedName);
        this.datatype = datatype;
    }

    public TaskVariable(String variableName, String access, String mappedName, Datatype datatype, String initialValue) throws TypeConversionException {
        super(variableName, access, mappedName);
        this.datatype = datatype;
        new DatatypeConverter().convert(initialValue, this.datatype);
        this.initialValue = initialValue;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public boolean hasValue() {
        return this.initialValue != null;
    }

    public Object initialValue() {
        if (this.initialValue == null) {
            return null;
        }
        try {
            return new DatatypeConverter().convert(this.initialValue, this.datatype);
        }
        catch (TypeConversionException e) {
            throw new Error();
        }
    }

    public boolean isAttachment() {
        return this.access.hasAccess(ACCESS_ATTACHMENT);
    }

    @Deprecated
    public boolean isWOKey() {
        return this.access.hasAccess(ACCESS_LITERAL_WOKEY);
    }

    @Deprecated
    public boolean isShowInUI() {
        return this.access.hasAccess(ACCESS_LITERAL_SHOW_IN_UI);
    }

    public String toString() {
        return "Name " + this.variableName + ", " + "type " + (Object)((Object)this.datatype) + (this.isRequired() ? ", required" : "") + (this.initialValue != null ? ", value " + this.initialValue : "");
    }
}

