/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcegroup;

import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;

public class LocalResourceGroupService
extends ResourceManagementService
implements IResourceGroupService,
IResourceTypeIdAware {
    private final ThreadLocal<Long> localResourceTypeId = new ThreadLocal();

    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        for (Serializable key : localKeys) {
            Collection groups = cache.get(key);
            if (groups == null) continue;
            for (ResourceGroup cachedGroup : groups) {
                resourceGroupList.add(this.clone(cachedGroup));
            }
        }
        return resourceGroupList;
    }

    @Override
    public List<ResourceGroup> getVisibleResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        for (Serializable key : localKeys) {
            Collection groups = cache.get(key);
            if (groups == null) continue;
            for (ResourceGroup group : groups) {
                if (!group.isVisible()) continue;
                resourceGroupList.add(this.clone(group));
            }
        }
        return resourceGroupList;
    }

    @Override
    public ResourceGroup getResourceGroup(long resourceGroupId) throws FinderException {
        ResourceGroup match = null;
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getResourceTypeCache().localKeySet()) {
                match = this.getResourceGroup(cache.get(key), resourceGroupId);
                if (match == null) {
                    continue;
                }
                break;
            }
        } else if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId)) {
            match = this.getResourceGroup(cache.get((Serializable)resourceTypeId), resourceGroupId);
        }
        if (match == null) {
            String msg = "Could not find Resource Group with Id: " + resourceGroupId;
            throw new FinderException(msg);
        }
        return match;
    }

    private ResourceGroup getResourceGroup(Collection<ResourceGroup> groups, long resourceGroupId) {
        if (groups != null) {
            for (ResourceGroup group : groups) {
                if (group.getId() != resourceGroupId) continue;
                return this.clone(group);
            }
        }
        return null;
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        Collection groups;
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId) && (groups = this.getResourceGroupCache().get((Serializable)Long.valueOf(resourceTypeId))) != null) {
            for (ResourceGroup cachedGroup : groups) {
                resourceGroupList.add(this.clone(cachedGroup));
            }
        }
        return resourceGroupList;
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResource(long resourceId) {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        Resource resource = new Resource(resourceId);
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getResourceTypeCache().localKeySet()) {
                if (!this.getResourceGroupsByResource(cache.get(key), resource, resourceGroupList)) continue;
                return resourceGroupList;
            }
        } else if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId)) {
            this.getResourceGroupsByResource(cache.get((Serializable)resourceTypeId), resource, resourceGroupList);
        }
        return resourceGroupList;
    }

    private boolean getResourceGroupsByResource(Collection<ResourceGroup> groups, Resource resource, List<ResourceGroup> result) {
        boolean added = false;
        if (groups != null) {
            for (ResourceGroup group : groups) {
                if (!group.getResources().contains(resource)) continue;
                result.add(this.clone(group));
                added = true;
            }
        }
        return added;
    }

    @Override
    public ResourceGroup getResourceGroupByToken(long tokenId) {
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        for (Serializable localKey : localKeys) {
            Collection groups = this.getResourceGroupCache().get(localKey);
            if (groups == null) continue;
            for (ResourceGroup group : groups) {
                if (group.getQueue().findItem(tokenId) == null) continue;
                return this.clone(group);
            }
        }
        return null;
    }

    @Override
    public ResourceGroup setResourceGroupQueueUIVisibility(long resourceGroupId, boolean visible) throws FinderException, DataOperationException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            if (resourceGroup.isVisible() == visible) {
                ResourceGroup resourceGroup2 = this.clone(resourceGroup);
                return resourceGroup2;
            }
            Session session = this.getPersistenceService().getCurrentSession();
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceGroupDAI dao = factory.getResourceGroupDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                ResourceGroup clone = this.getCloneService().cloneResourceGroup(resourceGroup, false);
                clone.setVisible(visible);
                dao.update(clone);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException e) {
                this.getPersistenceService().rollbackTransaction(session);
                throw e;
            }
            resourceGroup.setVisible(visible);
            container.updateEntity();
            ResourceGroup resourceGroup3 = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup3;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public ResourceGroup moveQueueItemToTop(long resourceGroupId, long resourceGroupItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemToTop(resourceGroupId, resourceGroupItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public ResourceGroup moveQueueItemToBottom(long resourceGroupId, long resourceGroupItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemToBottom(resourceGroupId, resourceGroupItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public ResourceGroup moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemUp(resourceGroupId, queueItemId, neighborQueueItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    @Override
    public ResourceGroup moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemDown(resourceGroupId, queueItemId, neighborQueueItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private boolean verifyContainerReady(long resourceGroupId, ResourceGroupContainer container) {
        Long resourceTypeId;
        if ((container == null || container.isStopped()) && (resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId)) == null) {
            return false;
        }
        String name = "resource group[" + resourceGroupId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        return true;
    }

    private void failQueueOperation() throws ActionException {
        String message = "The workorder selected to move is no longer in the queue.";
        throw new ActionException(message, "QE-100");
    }

    private Long getResourceTypeIdForRequest() {
        return this.localResourceTypeId.get();
    }

    @Override
    public void setResourceTypeIdForRequest(Long resourceTypeId) {
        this.localResourceTypeId.set(resourceTypeId);
    }

    @Override
    public void removeResourceTypeIdForRequest() {
        this.localResourceTypeId.remove();
    }

    private ResourceGroup clone(ResourceGroup group) {
        return this.getCloneService().cloneResourceGroup(group);
    }

    @Override
    public String getServiceName() {
        return "LocalResourceGroupService";
    }

    private IDistributedCache<ResourceType> getResourceTypeCache() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroupCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainerCache() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private ILocatorService getLocatorService() {
        return (ILocatorService)this.getRegistry().lookup(ILocatorService.class);
    }

    private IHibernatePersistenceService getPersistenceService() {
        return (IHibernatePersistenceService)this.getRegistry().lookup(IHibernatePersistenceService.class);
    }

    private ICloneService getCloneService() {
        return (ICloneService)this.getRegistry().lookup(ICloneService.class);
    }

    private IResourceAllocationService getAllocationService() {
        return (IResourceAllocationService)this.getRegistry().lookup(IResourceAllocationService.class);
    }

    private IContainerService getContainerService() {
        return (IContainerService)this.getRegistry().lookup(IContainerService.class);
    }
}

